--$Name: Im Dienste des Brazoragh$
--$Name(ru): Служа Бразорагу$
--$Version: 0.2$
--$Author: kerbal$
instead_version "2.4.1"

require "cutscene"
--require "keyboard"
--require "debug"
--require "xact"
--require "fonts"
require "dash"
require "para"
require "quotes"
--require "proxymenu"
require "sound"
--[[game.fading = function()
end;]]

global{
cur_vin = 12,
base_vin = 12,
cur_mas = 6,
base_mas = 6,
enemy_vin = 0,
enemy_mas = 0,
damage_count = 0, --счётчик для ущерба выносливости
fight_count = 0, --счётчик пропущенных ударов
enemy_damage = 0,
you_damage = 0,
round_count = 0,
}

game.forcedsc = true
game.gui.ways_delim = " "
stead.cut_scroll = true
stead.cut_delim = txtc('^ *** ^')

pic_1 = obj{
	nam = 'pic_1';
	dsc = txtc('^'..img('pic/1.png')..'^Это ты')
}:disable();

pic_2 = obj{
	nam = 'pic_2';
	dsc = txtc('^^'.. img('pic/2.png')..'^Ты участвуешь в выборах нового вождя')
}:disable();

pic_3 = obj{
	nam = 'pic_3';
	dsc = txtc('^'..img('pic/3.png')..'^Похоже, у племени новый вождь – ТЫ!')
}:disable();

stat_vin = stat{
nam = function()
return txtl("Выносливость: "..cur_vin);
end;
}

stat_mas = stat{
nam = function()
return txtl("Мастерство: "..cur_mas);
end;
}

oskolok = stat{
nam = 'oskolok',
disp = txtl("^^Осколок кристалла"),
}

izzragx = stat{
nam = 'izzragh',
disp = txtl("Иззрагх"),
}

galery_btn = obj{
nam = 'galery_btn',
disp = txtl("^Галерея"),
inv = function()
walk ('galery');
end,
}

main = room{
	nam = true,
	entered = function()
		objs("galery"):disable "pic_1";
		objs("galery"):disable "pic_2";
		objs("galery"):disable "pic_3";
	inv():zap();
	end;
	obj = {vway('начать', txtc('^^{Интро}.^'), 'intro'),vway('обигре', txtc('^{Об игре}.^^'), 'about')}
}

about = cutscene{
	nam = true,
	dsc = [[
	^^Название: Служа Бразорагу (Im Dienste des Brazoragh)
	^^Автор: Йорг Раддатц (Jörg Raddatz)
	^^Перевод: Златолюб
	^^Программирование: kerbal
	]],
	obj = {vway('назад', txtc('^^{Назад}.^'), 'main')},
}

galery = room{
	nam = true,
	entered = function()
		inv():disable 'galery_btn';
	--	remove('galery_btn', me());
	end;
	act = function(s,w)
	if w == 'back' then
		inv():enable 'galery_btn';
	--	place(galery_btn, me());
		walkback();
	end;
	end,
	dsc = '',
	obj = {vobj('back', txtc('{Назад}^')),'pic_1', 'pic_2', 'pic_3'},
}

intro = cutscene{
	nam = true,
	dsc = function(s)
	p '{code inv():zap()}'
	p '{code base_vin = 12}{code base_mas = 6}'
	pn [[ Обычно в мире Авентурии ты играешь роль героя. Но на сей раз тебе предстоит из первых рук узнать кое-что о типичных чертах культуры орков и их психологии, потому что в этом приключении ты – ОРК!
	Приключение использует стандартные правила «Боевой фэнтези», но без Удачи (плохие времена настали для всего вашего племени, какая уж тут Удача]]
	pn '{cut}'
	pn [[ Простоты и быстроты ради все сражения с несколькими противниками отыгрываются как сражение с единым существом с объединенной Выносливостью. Поскольку между боями обычно проходит несколько дней, считается, что каждый новый бой ты начинаешь со свежими силами (то есть восстановленной Выносливостью).]]
	p '{cut}'
	p ''
	p '{cut Проверим выносливость}{code cur_vin = base_vin + rnd(1,6) + rnd(1,6)}{code base_vin = cur_vin}'
	p '{code place(stat_vin, me())}'
	p '{cut Проверим мастерство}{code cur_mas = base_mas + rnd(1,6)}{code base_mas = cur_mas}'
	p '{code place(stat_mas, me())}'
	p '{cut Хм, неплохо.}'
	p '{code place(galery_btn, me())}'
	p '{walk r1}'
	end,
}

r1 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code cur_vin = base_vin}'
	p '{code ways():disable_all()}'
	p '{code objs("galery"):disable "pic_1"}'
	p '{code objs("galery"):disable "pic_2"}'
	p '{code objs("galery"):disable "pic_3"}'
--	p '{code place(galery_btn, me())}'
	pn [[ Зловещая тишина пала на пространную пустыню Омлогх Оркхай, дом твоего народа – даже у отважнейших воинов встает дыбом густая шерсть на спине, вся лесная дичь в страхе притихла, и даже немногие степные цветы стелются к земле, будто испугавшись. Потому что сегодня Турим Тайракхи, ночь Красной луны – сквозь густую пыль, затянувшую небо над головой, луна сегодня кажется ошарашенному наблюдателю не желтой, а темной, цвета свернувшейся крови.]]
	pn '{cut}'
	pn [[ Ты один из них, сильный и гордый воин племени Мургашай. Твои соплеменники обычно восхищаются тобой, твоим мужеством и твоей силой, но даже ты чувствуешь сегодня себя подавленным – слишком много произошло за последние десятидневки и луны, чтобы сомневаться, что ты навлек на себя гнев богов. Охота все хуже и хуже, распри с соплеменниками все сильнее, крестьяне не в состоянии обеспечить едой, и как их ни наказывай, продолжают что-то лепетать о неурожае и бедствиях.]]
	pn '{cut}'
	p '{code objs("galery"):enable "pic_1"}'
	pn [[ Всего лишь вчера двое твоих рабов проявили непослушание, и тебе с сожалением пришлось их убить, особенно жаль тебе гладкокожую человеческую женщину, неплохо служившую тебе.]]
	pn '{cut}'
	pn [[ Вместе с множеством других воинов из касты бдящих ты сейчас стоишь в бледно-красном свете луны – солнце уже скрылось за горами у Края Света – стоишь перед шатром жреца Тайраха и ждешь. Но старый Моргхинак может покочевряжиться – сегодня его ночь, и ему нет дела до невысказанного желания племени преклонить голову перед началом похода. И потому ты стоишь и ждешь, глядя, как дым выползает из щелей между шкурами шатра, а небо тем временем темнеет.]]
	pn '{cut}'
	pn [[ Но наконец, раздается хриплый кашель, и служащие дверью шкуры откидываются в сторону. Наружу выходит шаман Моргхинак, с головы до пят закутанный в красный шелк (ты тогда был среди тех, кто захватил его у Гладкокожих), на груди его сияет в темноте лунный диск из кованой меди – образ красного диска в пыльных небесах. На лице жреца Тайраха блуждает странная усмешка. Сегодня ожидается великая жертва – не дичь, даже не раб. Свободный орк, вот кто это будет!]]
	pn '{cut}'
	pn [[ Медленно, запинаясь, все еще одурманенный дымом трав, начинает свою речь Моргхинак:
	- Услышьте меня, я взмолился Тайраху и предложил ему мою кровь, умоляя его просветить меня, в чем причина гнева Бессмертного. И молитвы мои были громкими, а жертва доброй, ибо обрел знание знаний – боги гневаются, поскольку один из слуг ослушался их повелений, поскольку у Бразорага, Могучего Владыки, есть жрец, силы не имеющий, однако от боя укрывающийся, да бахвалящийся. Узрите же, старый долг на Шаркаке, вожде, сила его иссякла, а потому утратил он и милость у богов – лишь его кровь одна может вернуть ее!]]
	pn '{cut}'
	pn [[ Среди вас поднимается волнение – разве не вел Шаркак ваше племя к победе над многими кланами? Да, он стар и видел много весен, но он по-прежнему может одолеть любого претендента. Но с другой стороны, а когда ему в последний раз бросали вызов? Разве не признак того, что все племя изменило бразораговым заповедям, раз орки не дерутся промеж собой?]]
	pn '{cut}'
	pn [[ Такие бормотания проносятся по толпе воинов, пробужденные речью шамана. Но, несмотря на это бурление, Шаркак в племени по прежнему неоспоримый вождь и жрец Бразорага.]]
	pn '{cut}'
	pn [[ Он быстро пресекает дальнейшие волнения, опираясь на свой авторитет вождя и жреца Бразорага, чье мнение единственно имеет значение. Однако шерсть его вздыбилась и блестит от пота, а челюсть дрожит от гнева. И вы разом понимаете, что перед вами старик.]]
	p '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc("Можно призвать соплеменников проявить мягкость, снисходительность и благодарность к старому герою.^"), "r8"), vroom(txtc("^Можно вызвать вождя на смертный бой.^"), "r23"), vroom(txtc("^Или просто подождать и посмотреть, что будет дальше.^^"), "r16")}
}

r2 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Двигаясь на полдень, ты пересекаешь сперва горную гряду, за которой, насколько тебе известно по предыдущим походам, раскинулась степь, только более скудная и менее населенная. За степью лежат поросшие густым лесом горы, а за ними – земли людей.]]
	pn '{cut}'
	pn [[ Спустя несколько дней пути, ты выходишь к очень странной горе, торчащей на тускло-рыжей равнине – отвесные стены, куча углов и граней, из серого камня. Вокруг горы снуют пешком и верхом бесчисленные гладкокожие, и они же торчат в многочисленных входах в пещеры этой горы.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно подойти к этой странной горе.^^'), 'r12'); vroom(txtc('^Но будет мудрым пройти мимо.^^'), 'r29')}
}	
r3 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ На всякий случай ведешь себя на редкость миролюбиво – не стоит недооценивать столь богатого верховного вождя. А он и впрямь уверен в своей силе, потому что осуждающе говорит: «Не порите чушь, господин советник! Орк довольно смирный, и даже если он и доставит проблемы, так для чего же нам верховный маг, верно доктор»?]]
	pn '{cut}'
	pn [[ Затем толстый вождь поднимается и произносит: «Да сколько уже можно. Мы так долго обсуждаем, что и помереть можно». Тут человек, называемый «магом», делает тебе знак следовать за ним.]]
	pn '{cut}'
	pn [[ Длинными коридорами тебя отводят в пещеру, где полно разных странных предметов. Там тебя оставляют сидеть на какой-то деревяшке и начинают изучать осколок.]]
	pn '{cut}'
	pn [[ Наконец маг достает мешочек, трубку, открывает мешочек и зло бормочет: «Проклятье, дым-трава закончилась». Очевидно, что ему недостает материала для мощных чар.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно предложить ему сон-траву шамана.^^'), 'r38'); vroom(txtc('^Или воздержаться от этого^^'), 'r36')}
}
	
r4 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Заикаясь от испуга, один из оборванцев-изгнанников проблеял:
	- Да, ох, ваша милость, высокий господин, там за горами лежит страна ужасных чудовищ, с гладкой кожей и ужасными красными и желтыми волосами.]]
	pn '{cut}'
	pn [[ Они обрушились на нас, бедных странствующих орков, убивая направо и налево. Вам лучше не ходить туда господин, нет, не надо!]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('Можно прислушаться к предупреждению и двинуться обратно.^^'), 'r28'); vroom(txtc('^Или возмутившись этим жалким лепетом, отвесить слабакам затрещину и храбро идти вперёд^^'), 'r14')}
}

r5 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ И действительно, на этом широком поле произошла великая битва, но когда ты прибыл туда, все уже кончилось, и лишь искалеченные трупы покрывали землю.]]
	pn '{cut}'
	pn [[ А, нет – вдали что-то шевельнулось! Голый гладкокожий? Когда существо подошло поближе, ты понял, что это людоед, кошмарная гора мышц, но намного тупее орка вроде тебя.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно уклониться от встречи и покинуть поле боя.^^'), 'r39'); vroom(txtc('^Или отважно подождать его.^^'), 'r9')}
}

r6 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Смерть старого вождя и отсутствие преемника создают угрожающую ситуацию для племени – вскоре, как известно из опыта других племен, разгорится кровавая борьба за место вождя, орк против орка, в которой поляжет не менее половины воинов племени.]]
	pn '{cut}'
	pn [[ Но тут Моргхинак возвысил свой голос: 
- Услышьте, нет благословения в том, чтобы племя предавалось самоизбиению. Проявите силу и мужество, вы, кто хочет быть вождем, но не против друг друга, а в сражении с внешним миром.]]
	pn '{cut}'
	pn [[ Отправляйтесь в странствие и принесите через три луны трофеи. Чьи трофеи будут свидетельствовать о лучшем бое и величайшей победе, тот и станет новым вождем!]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно остаться в своем шатре со своими женщинами.^^'), 'r20'); vroom(txtc('^Или последовать призыву и отправиться в странствие.^^'), 'r28')}
}	

r7 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Ты отправился в направлении заката, навстречу горам Конца Мира и повстречал по дороге двух орков-чужаков, изгнанников из касты Юрах, которые робко сдались после короткой борьбы. ]]
	pn '{cut}'
	pn [[ Их снаряжение гораздо скуднее твоего, поэтому никакой добычи ты с них не получил.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно спросить куда они направляются.^^'), 'r4'); vroom(txtc('^Или счесть, что возня с такими ничтожествами ниже твоего достоинства.^^'), 'r14')}
}	

r8 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ На волосатых лицах твоих соплеменников отражается недоумение – такого неоркского поведения никто от тебя не ожидал, лишь слабаки ведут себя так.]]
	pn '{cut}'
	pn [[ 	Ты понимаешь, что совершил роковую ошибку – бывшие товарищи с яростным криком обрушиваются на тебя. Ты доблестно отбивался, но их превосходство и гнев на отступника слишком велики.]]
	pn '{cut}'
	pn [[ Краем глаза замечаешь, как в вихре ударов и тумаков валится на землю окровавленный Шаркак – последнее, что ты видишь в этой жизни.]]
	p '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Тебя накрывает красная волна лунного света, и ты погибаешь.^^^^^'), 'r42')}
}	

r9 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Без страха стоишь и ждешь – людоед ковыляет к тебе, лениво жуя человеческую руку. Вот его тусклые глаза пристально уставились на тебя – возможно, отставшего от Великой армии и тоже решившего подкрепиться.]]
	pn '{cut}'
	pn [[ Глухо чавкая, он здоровается с тобой:
	- У, орк! Хорошее место, много-много жратвы! – Затем что-то, похоже, шевельнулось в его маленькой черепушке: - У, орк, ты насяльника?
	]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно отвергнуть предложение людоеда стать твоим оруженосцем.^^'), 'r39'); vroom(txtc('^Или посостязаться с ним за главенство.^^'), 'r30')}
}	
r10 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Схватив разукрашенные пластины, отступаешь назад. По пути из этой странной горы несколько гладкокожих попытались было тебя остановить, но твой рев вселил в них страх, и они трусливо удрали.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно пореветь ещё и двинуться дальше.^^'), 'r32')}
}

r11 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Впечатленный дарами, решаешь остаться с новыми товарищами и продолжать войну с вашим общим врагом.]]
	pn '{cut}'
	pn [[ Много новых и странных вещей повидал ты за эти дни, вскоре ты уже научился отдавать команды на языке людей и повел гораздо больший отряд людей и орков во много добрых битв за поля, стада и большие города вроде Йоборна, которые удавалось захватить у врагов на какое-то время.]]
	pn '{cut}'
	pn [[ Все больше слабело твое желание вернуться, ведь ты получил все, чего только мог пожелать: битвы, власть и много послушных подчиненных, а ведь был еще и приятный напиток, называемый пивом, в изобилии оставляемый в шатрах гладкокожих, стоило только тебе с твоим войском куда-либо прибыть.]]
	pn '{cut}'
	pn '{cls}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc(' Воистину, ты, «генерал королей», как тебя теперь называли, обрел свое счастье!^^^^^^^'), 'main')}
}	

_r12 = cutscene{
	nam = 'r12',
	dsc = function(s)
--	p '{code ways():disable_all()}'
	pn [[ При твоем приближении люди обратили на тебя внимание: «Внимание, орк»! – пронеслось по их рядам. С удовлетворением отмечаешь, что ты и твой народ им хорошо знакомы – часть разбежалась с испугу, а остальные похватали оружие. Ты тоже крепко сжимаешь саблю и отважно устремляешься вперед.
	Наконец ты сходишься с тремя гладкокожими с топорами в руках:

Три солдата-андергастерца: Мастерство 8; Выносливость 24

	Если ты погибнешь в первые четыре раунда боя, прочти параграф 42, в противном случае отправляйся на параграф 24.]]
	pn '{cut}'
	pn '{walk fight_ander}'
	end,
}	

r12 = room {
	nam = true,
	entered = function()
	inv():disable 'galery_btn';
	enemy_vin = 24;
	enemy_mas = 8;
	end,
	act = function()
	if round_count < 3 then
		if cur_vin > 0 then 
		you_damage = cur_mas + rnd(1,6) + rnd(1,6);
		enemy_damage = enemy_mas + rnd(1,6) + rnd(1,6);
			if you_damage > enemy_damage then
			enemy_vin = enemy_vin - you_damage + enemy_damage
			else cur_vin = cur_vin - enemy_damage + you_damage
			end
		else walk ('r42')
		end
	pn ("Солдаты-андергастерцы:^Выносливость - "..enemy_vin.."^Мастерство - "..enemy_mas )
	else
		round_count = 0;
		walk ('r24');
	end	
	round_count = round_count + 1
	end,
	left = function()
	inv():enable 'galery_btn';
	end;
	dsc = [[При твоем приближении люди обратили на тебя внимание: «Внимание, орк»! – пронеслось по их рядам. С удовлетворением отмечаешь, что ты и твой народ им хорошо знакомы – часть разбежалась с испугу, а остальные похватали оружие. Ты тоже крепко сжимаешь саблю и отважно устремляешься вперед.
	Наконец ты сходишься с тремя гладкокожими с топорами в руках.]],
	obj = {vobj('fight', txtc('{Атаковать!}'))}
}
	
r13 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Золотой ключ с самоцветом? А где это ты его раздобыл? Пока ты размышляешь над ответом, все вокруг затуманивается.]]
	pn '{cut}'
	pn [[Просыпаешься от яркого, хотя и неправдоподобного сна – должно быть, перед походом ты перебрал шамановой сон-травы для храбрости… ]]
	pn '{cut}'
	pn [[Однако времени до конца срока не так уж и много.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^После быстрых приготовлений отправляешься в путь.^^'), 'r22')}
}

r14 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Степь кажется бесконечной, один за другим тянутся низкие ряды холмов, ночь проходит за ночью, освещаемая бледным лунным светом, но, в конце концов, ты приходишь к Краю Мира и окружающим его горам. Прямо перед тобой опускается кроваво-красное солнце.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно передумать, и, описав широкую дугу, вернуться к родному племени.^^'), 'r22'); vroom(txtc('^Но, если тебя не пугает лежащее впереди, можно следовать дальше.^^'), 'r26')}
}	

r15 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code objs("galery"):enable "pic_2"}'
	pn [[ Ты вышел из боя победителем – перед тобой в бледно-красном свете луны лежит труп Шаркака. Шаман поспешно проливает на пыльную землю кровь – подношение богам – и согласно древним обычаям отсекает голову Шаркака зазубренным медным ножом. Завершив церемонию, он оборачивается к тебе.]]
	pn '{cut}'
	p '{code if damage_count < 7 and fight_count < 3 then walk ("r34"); else walk ("r21") end;}'
--[[	Если ты потерял в бою с вождем всего 6 Выносливостей или меньше, иди на параграф 34.
	Если же ты пропустил больше двух ударов, прочти параграф 21.]]
	end,
}

r16 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Когда никто так и не бросил ему вызов, Шаркак с триумфом в голосе обозвал вас жалкими негодяями и бунтарями и объявил свою волю – убить Моргхинака.]]
	pn '{cut}'
	pn [[ Шаман умоляюще повалился перед ним на колени – но лишь затем, чтобы воткнуть медный нож в живот вождя. Гневно булькнув, Шаркак неуклюже повалился назад, и вскоре Моргхинак закончил свою кровавую работу – несколькими взмахами ножа он отсек голову вождя и преподнес ее в жертву богам.]]
	pn '{cut}'
	pn '{walk r6}'
	end,
}

r17 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Весь израненный, отправляешься назад, не обращая внимания на терзающую тебя боль, как и положено орку. Но шагая по степи, ты теряешь все больше и больше сил, ослабев настолько, что не можешь охотиться.]]
	pn '{cut}'
	pn [[ Как во сне видишь нескольких орков. Слабым голосом просишь у них мяса, но те лишь насмехаются над тобой:
	- Ха, высокий господин, мы уже не такие высокие, да? Валяемся здесь в грязи! Ха! Почувствовал, что значит получить по рогам?]]
	pn '{cut}'
	pn [[ Неимоверно медленно к тебе приближается рука с камнем. Раздается хруст, и тебя захлестывает волна багровой мути.]]
	pn '{cut}'
	pn '{walk r42}'
	end,
}

r18 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Когда рывшиеся в твоих пожитках гладкокожие обнаружили подарок шамана, они как с ума посходили – все разом галдят и передают осколок кристалла из рук в руки.]]
	pn '{cut}'
	pn [[ Спустя какое-то время они, похоже, пришли к какому-то решению, потому что тебя снова хватают и суют в странную повозку, которая по краям закрывается железными прутьями, и где так восхитительно пахнет свиньями – а еще аппетитнее выглядят пара быков перед повозкой.]]
	pn '{cut}'
	pn [[ В животе у тебя бурчит все чаще и чаще – теперь ты узник, и следующие несколько дней кормят тебя очень скудно.]]
	pn '{cut}'
	pn [[ Глядя время от времени из повозки, видишь проплывающие мимо скопления хижин гладкокожих, а по подчиненному поведению людей заключаешь, что ты, вероятно, попал в руки воинам этого племени – скорее всего, они везут тебя к своему верховному вождю.]]
	pn '{cut}'
	pn [[ Наконец вы прибываете в большую человеческую деревню – ты за всю свою жизнь не видел такого большого поселения, тут должно быть столько гладкокожих, сколько пальцев на руках у десятка десяток воинов!]]
	pn '{cut}'
	pn [[ На краю этого поселения – люди-воины называют его Андергаст – видишь вздымающийся серый горный пик, похожий на тот, где тебя поймали, но намного больший…]]
	pn '{cut}'
	pn [[ Тебя везут вверх по головокружительной дороге, затем через каменную арку, позади которой широкая открытая долина – и там, в этом укрытом месте пред тобой предстает невообразимая роскошь.]]
	pn '{cut}'
	pn [[ Гладкокожие с оружием и в доспехах, снующие взад-вперед, прочие таскают туда-сюда полные еды корзины, и повсюду видно аппетитных свиней, собак и крыс.]]
	pn '{cut}'
	pn [[Тебя вытаскивают из повозки и отводят в пещерный зал, выглядящий по-настоящему величественно, в центре которого стоит на возвышении большой стул.]]
	pn '{cut}'
	pn [[ Там сидит очень объемистый человек – наверняка верховный вождь племени. Окружают его разные гладкокожие, а перед ним какой-то помост с тарелкой, на которой лежит источающий благоухание свиной окорок, который как раз и глодает толстяк.]]
	pn '{cut}'
	pn [[ Когда воины вводят тебя, он удивленно поднимает взгляд и цедит несколько слов на человеческой речи, которую ты благодаря своему прежнему рабу более-менее понимаешь: «В чем дело, холопы, не видно, что ли – мы кушаем»?]]
	pn '{cut}'
	pn [[ Но тут его маленькие глазки расширились, как будто этот боров что-то вспомнил: «А, это ты, мой верный фельдфебель, э-э, - он махнул куском тонкой ткани, пока другой человек что-то шептал ему. – Мой верный фельдфебель Рестелин с, э-э, орком, я полагаю. Так в чем же дело»?]]
	pn '{cut}'
	pn [[ Воин быстро рассказывает о твоем пленении, затем достает осколок кристалла. Среди людей раздалось удивленное бормотание. Бурно размахивая своей тряпочкой, толстый вождь наводит порядок и говорит: «Это наверняка важный магический артефакт, мы полагаем.]]
	pn '{cut}'
	pn [[ Тарлизин, наш верховный маг, возьми орка и осколок, и посмотри, нельзя ли из этого сделать секретное оружие против наших врагов».]]
	pn '{cut}'
	pn [[ Но тут подходит еще один человек и говорит, что ты наверняка слишком опасен, чтобы тебя исследовать.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно громко зареветь, напрячь мышцы чтобы разорвать верёвки и сбежать к повозке.^^'), 'r27'); vroom(txtc('^Или сохранять спокойствие.^^'), 'r3')}
}

r19 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ По дороге в земли восхода тебе встречалось все больше и больше орков из других племен, рассказывающие о могучем вожде и о войне с гладкокожими.]]
	pn '{cut}'
	pn [[ Многих орков собрал он и ворвался в плодородные долины за границами степи, грабить и разорять города и села людей.]]
	pn '{cut}'
	pn [[ Почти все, с кем ты заговаривал, шли, чтобы присоединиться к нему и добыть славу, власть и добычу – большие трофеи ждут на этом пути.]]
	pn '{cut}'
	pn [[ Ты решил поторопиться и спустя много дней пришел в страну, очень сильно отличающуюся от родной Пыльной степи – тут много воды, она даже образует большие реки и грязные лужи на земле, лужи невероятных размеров.]]
	pn '{cut}'
	pn [[ Благоразумно решив осмотреться, замечаешь на горизонте дым и чад, и кружащих стервятников – видимо, над полем боя.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно отправиться туда.^^'), 'r5'); vroom(txtc('^Или обойти это место.^^'), 'r39')}
}

r20 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Дни шли за днями, пока большинство воинов племени где-то скитались. Для тебя это время было нелегким – ты защищал племя от нападений других племен и несколько раз был на волосок от смерти.]]
	pn '{cut}'
	pn [[ Когда спустя три луны воины возвратились, Хулгхарук, твой заклятый враг, принес великолепные доспехи из железа и тем превзошел всех соперников.]]
	pn '{cut}'
	pn [[ Став вождем, он первым делом отнял твоих женщин – и разве такой трус как ты заслуживает чего-то иного?]]
	pn '{cut}'
	pn '{walk main}'
	end,
}

r21 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Посмотрев на твои раны, Моргхинак объявил, что боги, конечно же, благоволят тебе, однако для явного избранника Бессмертных ты получил слишком много ран. А потому, увы, говорить, что у племени новый вождь, еще рано.]]
	pn '{cut}'
	p '{code place(oskolok, me())}'
	p '{code place(izzragx, me())}'
	pn [[ В знак твоей победы шаман вручает тебе светящийся голубой осколок кристалла и мешочек с иззрагхом, сон-травой шаманов.]]
	pn '{cut}'
	pn '{walk r6}'
	end,
}

r22 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Долгие дни ты шел по бескрайним просторам Омлогх Оркхай, прежде чем встретил других орков. Времена, похоже, для всех трудные, и в большинстве случаев на тебя нападали.]]
	pn '{cut}'
	pn [[ И хотя твои сила и мужество приносили тебе победу, ты получил несколько серьезных ран и смог собрать лишь очень скудные трофеи – когда спустя три луны ты вернулся в свое племя, ты смог предъявить всего лишь пару единиц оружия да шкуру молодого медведя.]]
	pn '{cut}'
	pn [[ Когда шаман Моргхинак объявлял новым вождем твоего старого врага Хулгхарука, он смотрел на тебя как будто с насмешкой – разве может твоя добыча сравниться с великолепными железными доспехами.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Возможно, до самого конца своих дней, ты будешь простым воином.^^^^^^'), 'main')}
}	
	
_r23 = cutscene{
	nam = 'r23',
	dsc = function(s)
	pn [[ Желтые глаза Шаркака расширились – в испуге? – когда ты вышел из толпы воинов и крикнул, что убьешь его – в открытом бою тычками и пинками. Зарычав, он принял вызов, и бросился на тебя

Шаркак: Мастерство 8; Выносливость 8
	
	Может старый вождь и неповоротлив, но опытен – если уж его удары попадают в цель, то бьют наповал – ты теряешь по 3 очка Выносливости вместо 2.
	Нет нужды говорить, что твоя цель – убить противника. Если ты ее достигнешь, иди на параграф 15.
	Если твоя Выносливость упадет до 0, значит ты мертв и попал на параграф 42.
	Конечно, всегда можно прервать бой и на параграфе 8 взмолиться о пощаде и милосердии.
	]]
	pn '{cut}'
	pn '{walk fight_sharagh}'
	end,
}

r23 = room{
	nam = true,
	entered = function()
		inv():disable 'galery_btn';
		enemy_vin = 8;
		enemy_mas = 8;
		damage_count = 0;
		fight_count = 0;
--		place("pic_2", "galery");
	end,
	act = function(s,w)
	if w == 'fight' then
		if cur_vin > 0 then 
		you_damage = cur_mas + rnd(1,6) + rnd(1,6);
		enemy_damage = enemy_mas + rnd(1,6) + rnd(1,6);
			if you_damage > enemy_damage then
			enemy_vin = enemy_vin - you_damage + enemy_damage
			elseif you_damage < enemy_damage then
			cur_vin = cur_vin - math.ceil(((enemy_damage - you_damage)/2) * 3);
			damage_count = damage_count + math.ceil(((enemy_damage - you_damage)/2) * 3);
			fight_count = fight_count + 1;
			end;
		else walk ('r42');
		end;
		pn ("Вождь Шарагх:^Выносливость: "..enemy_vin.."^Мастерство: "..enemy_mas..'^^Пропущено ударов: '..fight_count..'^Получено ущерба: '..damage_count )
		if enemy_vin < 1 then walk ('r15');	end;
	else walk ('r8');
	end;
	end,
	left = function()
	inv():enable 'galery_btn';
	end;
	dsc = [[ Желтые глаза Шаркака расширились – в испуге? – когда ты вышел из толпы воинов и крикнул, что убьешь его – в открытом бою тычками и пинками. Зарычав, он принял вызов, и бросился на тебя.	
	Может старый вождь и неповоротлив, но опытен – если уж его удары попадают в цель, то бьют наповал.
	Нет нужды говорить, что твоя цель – убить противника. 
	Конечно, всегда можно прервать бой и взмолиться о пощаде и милосердии.]],
	obj = {vobj('fight', txtc('{^Атаковать!^}')),vobj('mercy', txtc('{^Просить пощады}'))}
}

r24 = cutscene{
	nam = true,
	dsc = function(s)
	p '{cls}'
	p '{code cur_vin = base_vin}'
	p '{code ways():disable_all()}'
	pn [[ Пока ты отважно сражался против втрое превосходящего противника, на тебя свалилась какая-то штуковина, состоящая из множества переплетающихся веревок.]]
	pn '{cut}'
	pn [[ Изо всех сил борешься с веревками, но чем сильнее сопротивляешься, тем крепче они тебя опутывают – в конце концов, падаешь на землю, замотанный в эти ужасные тенета, напоминающие паучью сеть.]]
	pn '{cut}'
	pn [[ Гладкокожие поднимают тебя как охотничий трофей и уносят, пока ты злобно осыпаешь их проклятьями, как на оркском, так и на языке людей, который ты выучил у рабов-гладкокожих.]]
	pn '{cut}'
	pn [[ Тебя занесли в странную гору – они называют ее «Андерштайн» на своем языке – заковали в кандалы, обезоружили и тщательно обыскали.]]
	pn '{cut}'
	p '{code if have("oskolok") then ways()[1]:enable(); else ways()[2]:enable();end;}'
--	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^У тебя есть осколок кристалла.^^'), 'r18'); vroom(txtc('^У тебя нет при себе осколка кристалла.^^'), 'r41')}
}	

r25 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Яростный бой все длится, и вам обоим уже не до того, чтобы смотреть по сторонам, поэтому ты удивился, когда могучая рука схватила твоего противника и подбросила высоко в воздух.]]
	pn '{cut}'
	pn [[ Человек с грохотом рухнул на землю и остался лежать без движения. Людоед с восторгом смотрит на него:
	- Здорово! Жратва!
	Похоже, он тоже не нашел себе другой добычи.]]
	pn '{cut}'
	pn [[ Тебе следует поторопиться, пока людоед пускает слюни при виде трупа]]
	pn '{cut}'
	pn '{walk r35}'
	end,
}

_r26 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Путь через горы оказался легче, чем ты думал – на деревьях полно вкусных фруктов, а охота хороша и стабильно приносит свежее мясо. Впервые с начала похода ты ощутил в сердце истинное умиротворение – когда ты станешь вождем, а в этом и состоит твое настоящее счастье, ты приведешь свое племя сюда, к жизни в довольстве – и все женщины будут твоими.
	Из мечтаний тебя вырвал голос, что-то говорящий на непонятном гортанном языке. Подняв взгляд, видишь неподалеку настоящих великанов, гладкокожих, все с пышными красными и белокурыми косами, в кожаных доспехах и с огромными топорами.

Четыре торвальца: Мастерство 10; Выносливость 40

	Противники стремятся просто убить тебя. Если у них это выйдет, ты отправишься на параграф 42.
	Но возможно, Бразораг не забудет о тебе, и ты сможешь одолеть всех противников – тогда можешь продолжать параграфом 31.]]
	end,
}

r26 = room{
	nam = true,
	entered = function()
		inv():disable 'galery_btn';
		enemy_vin = 40;
		enemy_mas = 10;
		cur_mas = base_mas;
		cur_vin = base_vin;
	end,
	act = function(s,w)
	if cur_vin > 0 then 
		you_damage = cur_mas + rnd(1,6) + rnd(1,6);
		enemy_damage = enemy_mas + rnd(1,6) + rnd(1,6);
		if you_damage > enemy_damage then
			enemy_vin = enemy_vin - you_damage + enemy_damage
		else cur_vin = cur_vin - enemy_damage + you_damage;
		end;
	else walk ('r42');
	end;
	pn ("Четыре торвальца:^Выносливость: "..enemy_vin.."^Мастерство: "..enemy_mas)
	if enemy_vin < 1 then walk ('r31');
	end;
	end,
	left = function()
	inv():enable 'galery_btn';
	end;
	dsc = [[ Путь через горы оказался легче, чем ты думал – на деревьях полно вкусных фруктов, а охота хороша и стабильно приносит свежее мясо. Впервые с начала похода ты ощутил в сердце истинное умиротворение – когда ты станешь вождем, а в этом и состоит твое настоящее счастье, ты приведешь свое племя сюда, к жизни в довольстве – и все женщины будут твоими.
	Из мечтаний тебя вырвал голос, что-то говорящий на непонятном гортанном языке. Подняв взгляд, видишь неподалеку настоящих великанов, гладкокожих, все с пышными красными и белокурыми косами, в кожаных доспехах и с огромными топорами.Четыре торвальца. Противники стремятся просто убить тебя
	Но возможно, Бразораг не забудет о тебе, и ты сможешь одолеть всех противников.]],
	obj = {vobj('fight', txtc('{^Атаковать!^}'))}	
}
	
r27 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Твой рёв столь громко разнесся по комнате, что все люди разом попятились. Напрягаешься, и твои путы начинают рваться, но тут в твою спину впивается что-то острое, а спереди в тебя врезается шар из огня.]]
	pn '{cut}'
	pn '{walk r42}'
	end,
}

r28 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Поспешно собираешь те немногие пожитки, которые тебе пригодятся в странствии – то, что и так на тебе надето, плюс верная сабля, кожаные доспехи да мешок с едой на несколько дней.]]
	pn '{cut}'
	pn [[ Одарив на прощание своих женщин дружескими шлепками, ты готов отправляться – осталось только выбрать дорогу.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно пойти на север - туда, где не светит солнце.^^'), 'r22'); vroom(txtc('^Можно направиться в сторону заката.^^'), 'r7'); vroom(txtc('^Или направиться в в сторону восхода.^^'), 'r19'); vroom(txtc('^И наконец, можно отправиться к полуденным горам^^'), 'r2')}
}

r29 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Обойдя странную гору и миновав обычные горы, ты оказался в стране, настолько непохожей на твой дом, что ты как будто попал в другой мир – ряд за рядом стоят деревья, воздух чист и почти повсюду течет свежая вода.]]
	pn '{cut}'
	pn [[ Тут, должно быть, легко найти счастье. Много дней идешь по этому краю, сытно питаясь обильной дичью и не слишком-то думая о своей задаче, потому что встречающиеся там и сям немногочисленные гладкокожие – существа безвредные, удирающие при одном твоем появлении, оставляя свои жалкие пожитки, лохмотья да скудную пищу – какие уж тут трофеи?]]
	pn '{cut}'
	pn [[ Лишь переправившись через широкий ручей, ты, наконец, выходишь к богатому укрепленному поселению.]]
	pn '{cut}'
	pn [[ Ты подходишь к неприступной стене из мощных стволов. За стенами стоят хижины, поднимается дым, раздается гомон, как будто там немалая суматоха. Но даже и снаружи этого поселения становится интересно – из-за стен выбегают вооруженные гладкокожие, а несколько выходит из-за деревьев, где ты прятался.]]
	pn '{cut}'
	pn [[ Слышишь за спиной зычный, привычный отдавать команды голос, голос великого вождя: «Смирно»!
	Медленно оборачиваешься. За спиной у тебя стоит человек, мужчина, выглядящий по-настоящему величественно – многочисленные цветные кусочки металла сверкают на его белых одеяниях, особенно много их на груди, голову защищает прочный шлем, увенчанный торчащим вверх рогом.]]
	pn '{cut}'
	pn [[ Человек задумчиво глядит на тебя через прикрывающие глаза похожие на лед пластинки – наверняка великое колдовство – и продолжает: «Тэк-с, что же тут у нас. Орк, так, так. Похоже, меня не обманули. Вероятно, дезертир с Ловангенского фронта, да? Впрочем, без разницы – не отставай»!]]
	pn '{cut}'
	pn [[ Небрежно, почти скучающе он указывает коротким хлыстом на группу гладкокожих. Ты не стал перечить, указывая на ошибку вождя, решив подождать, пока не узнаешь, какое именно оружие носит вождь гладкокожих…]]
	pn '{cut}'
	pn [[ Не успели вы войти внутрь стен, как вождь людей возобновил речь:
	- Добро пожаловать, солдаты, в эту прекрасную приграничную крепость нашей любимой Нострии. Вы избраны защищать наш дом от вражеских орд князя Андергаста.]]
	pn '{cut}'
	pn [[ Я ваш начальник, Хидлимер Леберехт, граф фон Эренбрюк Высокий Утёс, майор славной армии Его Величества короля Нострии. Вполне достаточно будет обращаться ко мне кратко «герр майор».]]
	pn '{cut}'
	pn [[ Вот и все, что вам пока надлежит знать, кроме того, что все мои команды надо выполнять безотлагательно. Разойдись!]]
	pn '{cut}'
	pn [[ Насколько ты можешь понять, ты попал в личный отряд этого важного вождя людей – уникальная возможность для большой добычи и великолепных трофеев.]]
	pn '{cut}'
	pn [[ Следующие несколько дней тебя и остальных воинов вождь натаскивал в различных военных премудростях, затем началась потеха – через небольшой ручеек хлынуло вражеское племя андергастцев.]]
	pn '{cut}'
	pn [[ Благодаря превосходству в военном искусстве вы быстро их одолели и обратили в бегство – ты собственноручно убил двух врагов.]]
	pn '{cut}'
	pn [[ После боя Герр Майор при всех похвалил тебя за подвиги и приколол тебе на одежду прекрасный блестящий кусочек металла.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно вернуться с этим знаком почестей в свое племя.^^'), 'r32'); vroom(txtc('^Но можно и остаться.^^'), 'r11')}
}	
-- обработка инвентаря - вкл-выкл переходы 
r30 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Он тупо смотрит на тебя, затем трясет башкой так, что недожеванная рука улетает.
	- Не-а, орк. Слишком маленький для насяльника. – Медленно он поворачивается и собирается тащиться прочь.]]
	pn '{cut}'
	p '{code if have("oskolok") then ways()[2]:enable(); else ways()[1]:enable();end;}'
	--p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно покинуть это бесперспективное поле боя.^^'), 'r39'); vroom(txtc('^У тебя есть осколок кристалла, чтобы впечатлить людоеда.^^'), 'r37')}
}	

r31 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Поздравляем, ты совершил почти невозможное – чудовища перед тобой лежат в собственной крови. Но и ты истекаешь кровью из многих ран, а потому предпочитаешь отступить, пока тебе не встретились еще такие чудовища.]]
	pn '{cut Чёт или нечёт?}'
	p '{code if rnd(1,6) > 3 then ways()[1]:enable(); else ways()[2]:enable();end;}'
--	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Выпало чётное число.^^'), 'r22'); vroom(txtc('^Выпало нечётное число.^^'), 'r17')}
}

_r32 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ После того как люди отказались отпустить тебя по-хорошему, ты легко обошелся без их согласия, вырвавшись и проложив себе дорогу обратно в родную Пыльную степь. Однако в родном племени твоей радости был положен конец – над твоими рассказами о чудесах мира втихомолку посмеивались, а твои истории о вражде человеческих племен пропускали мимо ушей, как ерундовые.
	Однако еще хуже было то, что твой старый соперник Хулгхарук по истечении срока вернулся с великолепными железными доспехами, перед которыми твои трофеи, естественно, меркнут. Его превосходство столь несносно, что тебе не остается ничего другого, как вызвать его на бой за титул вождя – вызов, который он принимает с глумливым смехом.

Хулгхарук: Мастерство 9; Выносливость 12

	Пробить надетые на нем доспехи нелегко – каждый твой удар отнимает у Хулгхарука лишь 1 Выносливость.
	Само собой, бой идет до смерти одного из вас. Если тебе не повезет, оправляйся на параграф 42.
	Однако если ты окажешься победителем, можешь прочесть параграф 34.]]
	end,
}

r32 = room{
	nam = true,
	entered = function()
		inv():disable 'galery_btn';
		enemy_vin = 12;
		enemy_mas = 9;
		cur_mas = base_mas;
		cur_vin = base_vin;
		objs("galery"):enable "pic_3";
	end,
	act = function(s,w)
	if cur_vin > 0 then 
		you_damage = cur_mas + rnd(1,6) + rnd(1,6);
		enemy_damage = enemy_mas + rnd(1,6) + rnd(1,6);
		if you_damage > enemy_damage then
			enemy_vin = enemy_vin - 1;
		elseif you_damage < enemy_damage then
		cur_vin = cur_vin - enemy_damage + you_damage;
		end;
	else walk ('r42');
	end;
	pn ("Хулгхарук:^Выносливость: "..enemy_vin.."^Мастерство: "..enemy_mas)
	if enemy_vin < 1 then walk ('r34');
	end;
	end,
	left = function()
	inv():enable 'galery_btn';
	end;
	dsc = [[ После того как люди отказались отпустить тебя по-хорошему, ты легко обошелся без их согласия, вырвавшись и проложив себе дорогу обратно в родную Пыльную степь. Однако в родном племени твоей радости был положен конец – над твоими рассказами о чудесах мира втихомолку посмеивались, а твои истории о вражде человеческих племен пропускали мимо ушей, как ерундовые.
	Однако еще хуже было то, что твой старый соперник Хулгхарук по истечении срока вернулся с великолепными железными доспехами, перед которыми твои трофеи, естественно, меркнут. Его превосходство столь несносно, что тебе не остается ничего другого, как вызвать его на бой за титул вождя – вызов, который он принимает с глумливым смехом. Пробить надетые на нем доспехи нелегко.
	Само собой, бой идет до смерти одного из вас.]],
	obj = {vobj('fight', txtc('{^Атаковать!^}'))}
}


r33 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Ты едва успел покинуть пещеру мага, когда сзади донесся рев ярости – но ты только увеличил скорость. По дороге ты обронил несколько кусков кожи (самому бы ноги унести), но, похоже, этого оказалось достаточно, чтобы отвлечь твоего преследователя.]]
	pn '{cut}'
	pn [[ Вместо того чтобы продолжать погоню, он принялся кропотливо собирать оброненную кожу. Это позволило тебе осуществить достойное отступление из этой странной горы гладкокожих.]]
	pn '{cut}'
	pn '{walk r32}'
	end,
}

r34 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code objs("galery"):enable "pic_3"}'
	p '{code ways():disable_all()}'
	pn [[ Глаза шамана оглядели твое сильное тело без изъянов, и громким голосом он произносит: 
- Услышь и возрадуйся, ты – достойный в глазах богов, героическим был твой отважный бой к их вящей славе. Знай же, что боги с тобой, и да будешь ты нашим новым вождем и принесешь нам благословение, служи Бразорагу, как мы будем служить тебе.]]
	pn '{cut}'
	pn [[ С этими словами Моргхинак берет рогатый шлем покойного вождя и водружает на тебя.
	Вскоре по толпе пронеслись бормотания, переросшие в громкие ликования – у племени Мургашай теперь есть новый вождь, время проклятия прошло, новая сила потечет через мир.]]
	pn '{cut}'
	pn [[ Для тебя же настало время радости – можешь брать, что пожелаешь, но еще и время борьбы, ибо многие молодые щенки пожелают одолеть тебя.]]
	pn '{cut}'
	pn [[ С каждым годом тебе будет все труднее править, взгляды твоих подданных будут все более нетерпеливыми, пока однажды Сильный не поднимет рогатый шлем, пока твоя кровь будет стекать на пыльную землю.]]
	pn '{cut}'
	pn '{walk main}'
	end,
}

r35 = cutscene{
	nam = true,
	dsc = function(s)
	pn [[ Быстро обшариваешь мертвеца – людоед нетерпеливо дожидается, когда ты закончишь. Металлическая бляха оказалась медной брошью в виде головы хищника – наверняка великий священный символ Тайраха, очень ценный трофей.]]
	pn '{cut}'
	pn [[ Довольный оставляешь людоеда чавкать и, покинув деревню, возвращаешься в свое племя, где производишь особое впечатление на старого шамана Моргхинака.]]
	pn '{cut}'
	pn '{walk r34}'
	end,
}

r36 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Разочаровано ворча, маг вновь принялся за осколок. Похоже, ему что-то пришло в голову, потому что он встал и отправился в другую пещеру, где принялся что-то искать. Ты воспользовался моментом – твои гнилые путы быстро лопнули.]]
	pn '{cut}'
	pn [[ Поспешный поиск трофеев принес тебе стопку тонких расписных кож с вытесненными металлом на верхней коже закорючками: Systeme der Magie von Rohal dem Weisen.]]
	pn '{cut}'
	pn [[ Мгновенно поколебавшись – а вдруг в этих непонятных закорючках заключены могучие охранные чары – хватаешься за стопку кож обеими руками. Штуковина оказалась слишком тяжелой, чтобы тащить ее целиком.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно выдерать из нее тонкие кожи, чтобы пошить прекрасные одеяния.^^'), 'r33'); vroom(txtc('^Или взять красивую крышку.^^'), 'r10')}
}	

r37 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ При виде яркого голубого осколка напуганный людоед бросается перед тобой ниц:
	- У, орк, хороший насяльника, большой насяльника! Приносить много-много жратвы!
	Со своим новым приверженцем покидаете поле боя.]]
	pn '{cut}'
	pn [[ На следующий день вам встречается скопление деревянных хижин, наверняка селение гладкокожих, но его обитатели трусливо удрали.
	Осматривая их деревню на предмет трофеев, ты наткнулся на большой дом, на котором висит деревянная доска с закорючками NORDLANDBANK.]]
	pn '{cut}'
	pn [[ Людоед не может протиснуться в узкий вход, но ты храбро заходишь внутрь и попадаешь в большую комнату.]]
	pn '{cut}'
	pn [[ В задней части комнаты стоит какая-то скамья, а за ней большая металлическая коробка со сложным замком – явно какой-то сундук с сокровищами. Коробка успешно устояла перед твоими попытками открыть ее.]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^С большим трудом можно вытащить её нанаружу, где её попытается открыть людоед.^^'), 'r40'); vroom(txtc('^Или у тебя есть золотой ключ с самоцветом?^^'), 'r13')}
}

r38 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Когда ты предложил ему иззрагх, он сперва удивился, но затем в знак благодарности освободил тебе руки, покопался в мешочке, набил свою трубку, поджег и вскоре погрузился в глубокий сон.]]
	pn '{cut}'
	pn [[ Само собой, ты можешь воспользоваться этой возможностью, чтобы сбежать, но сперва тихонько осматриваешься в пещере. Тут ты нашел теплый плащ, отделанный чудесными цветными камнями – великолепный трофей.]]
	pn '{cut}'
	pn [[ Затем, в основном благодаря везению, тебе удалось незамеченным выбраться из горы. Потратив на утомительные поиски следов много дней, ты, наконец, отыскал обратную дорогу в родную степь, где твой ценный трофей произвел большой фурор]]
	pn '{cut}'
	pn '{walk r34}'
	end,
}

r39 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Когда поле боя осталось позади, тебе стало встречаться все больше шныряющих вокруг орков из войска Великого Похода. Немного поразмышляв, понимаешь, что в одиночку у тебя неважные перспективы на трофеи.]]
	pn '{cut}'
	pn [[ Но уже в скором времени ты сумел доказать, чего стоишь, в бою с бесчисленными гладкокожими. В твои руки попала обильная добыча, но еще больше ждет тебя в будущем.]]
	pn '{cut}'
	pn [[ На удивление быстро ты позабыл свою первоначальную цель и остался с Великой армией, где можно достичь значительного положения, повидать чудеса и прийти на новые поля брани – вот только родного племени в бесплодной степи ты уже не увидишь.]]
	pn '{cut}'
	pn '{walk main}'
	end,
}

_r40 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Пока ты, утомившись, смотришь, огромный людоед несколько раз высоко поднимает и опускает на землю коробку. Из расколовшейся коробки хлынуло ее содержимое.]]
	pn '{cut}'
	pn [[ К несчастью, это поток твердых листов с изображением пчелы, черточек и завитушек – очень красивых на вид, но в качестве трофеев смехотворных и совершенно бесполезных.]]
	pn '{cut}'
	pn [[ Людоед разочаровано поплелся прочь – он явно ожидал, что внутри окажется что-то съестное – а ты вновь и вновь перерываешь бумажную кучу, тщетно пытаясь найти что-то еще.
	Неожиданно сзади раздается голос, спокойный и решительный:]]
	pn '{cut}'
	pn [[- Окэй, орк. Этот город слишком мал для нас двоих!]]
	pn '{cut}'
	pn [[
Быстро обернувшись, видишь человека. Он стоит, расставив ноги, пальцы нервно приплясывают у рукояти меча, а на куртке поблескивает металлическая бляха. Молниеносно вынимаешь саблю, но он выхватывает меч еще быстрее.

Городской стражник: Мастерство 10; Выносливость 8

	Если спустя восемь раундов боя вы оба еще живы, прочти параграф 25. Если до истечения этого срока погибнешь ты – прочти параграф 42, твой противник – параграф 35.]]
	end,
}

r40 = room{
	nam = "Бой с шерифом",
	entered = function()
		inv():disable 'galery_btn';
		enemy_vin = 8;
		enemy_mas = 10;
		round_count = 0;
		cur_mas = base_mas;
		cur_vin = base_vin;
	end,
	act = function(s,w)
	if round_count < 8 then
		if cur_vin > 0 then 
		you_damage = cur_mas + rnd(1,6) + rnd(1,6);
		enemy_damage = enemy_mas + rnd(1,6) + rnd(1,6);
			if you_damage > enemy_damage then
			enemy_vin = enemy_vin - you_damage + enemy_damage;
			else cur_vin = cur_vin - enemy_damage + you_damage;
			end;
		else walk ('r42');
		end;
		pn ("Городской стражник:^Выносливость: "..enemy_vin.."^Мастерство: "..enemy_mas)
		if enemy_vin < 1 then walk ('r35');
		end;
	else walk ('r25');
	end;
	round_count = round_count + 1;
	end,
	left = function()
	inv():enable 'galery_btn';
	end;
	dsc = [[ Пока ты, утомившись, смотришь, огромный людоед несколько раз высоко поднимает и опускает на землю коробку. Из расколовшейся коробки хлынуло ее содержимое.К несчастью, это поток твердых листов с изображением пчелы, черточек и завитушек – очень красивых на вид, но в качестве трофеев смехотворных и совершенно бесполезных.
	Людоед разочаровано поплелся прочь – он явно ожидал, что внутри окажется что-то съестное – а ты вновь и вновь перерываешь бумажную кучу, тщетно пытаясь найти что-то еще.
	Неожиданно сзади раздается голос, спокойный и решительный:
	- Окэй, орк. Этот город слишком мал для нас двоих!
	Быстро обернувшись, видишь человека. Он стоит, расставив ноги, пальцы нервно приплясывают у рукояти меча, а на куртке поблескивает металлическая бляха. Городской стражник. Молниеносно вынимаешь саблю, но он выхватывает меч еще быстрее.]],
	obj = {vobj('fight', txtc('{^Атаковать!^}'))}
}

r41 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ Теперь ты стоишь на открытом пространстве в середине круглой горы и ждешь своей незавидной участи.]]
	pn '{cut}'
	pn [[ Стоящие рядом люди что-то обсуждают – в основном слышишь невразумительное бормотанье, но иногда улавливаешь понятные отрывки: «…что за бессмысленный расход…» и «Полагаю, мы должны его спросить… Если он не хочет, чтобы его убили, мы можем…»]]
	pn '{cut}'
	pn [[ Наконец, один из этих людей обращается к тебе – судя по большому животу и роскошному меху на лице, это очень могущественный вождь гладкокожих.]]
	pn '{cut}'
	pn [[ - Здравствуй, орк. Ты меня понимаешь, верно? Ты сильный воин, это так, и неплохо управляешься с саблей. Как насчет сразиться с нострийскими глупцами и отвесить им смачных пинков? Что скажешь?]]
	pn '{cut}'
	pn [[ Ты не очень многое понял из людских разговоров, но догадываешься, что тебя хотят завербовать в качестве воина для боя с другим племенем.]]
	pn '{cut}'
	pn [[ Медленно обводишь глазами по сторонам. Не похоже, чтобы это племя было богатым – большинство воинов носят простые штаны и рубахи из ткани, и лишь на толстом вожде надет шлем, но с другой стороны, любая война означает добычу, и кто знает, если ты пойдешь с ними, тебе, глядишь, и повезет…]]
	pn '{cut}'
	pn [[ Похоже, твое согласие привело вождя в восторг, и он приветствует тебя в рядах «Королевской армии Андергаста».]]
	pn '{cut}'
	pn [[ В последующие дни он сколачивал отряд из своих воинов из горных пещер и других орков, и, наконец, вы отправились в сторону полудня.]]
	pn '{cut}'
	pn [[ Ваш путь пролегал через горы и стремительную реку. Сам ты, во главе отряда из более чем двух рук орков, повидал много чудес, о которых долго еще будешь рассказывать.]]
	pn '{cut}'
	pn [[ Наконец вы перешли брод и обрушились на врагов – ненавистных нострийцев. Быстро завязалась жестокая сеча, в которой твои новые товарищи показали себя добрыми рубаками – столь неукротимо и яростно орудовали они топорами, дубинками и кулаками, что враг быстро отступил.]]
	pn '{cut}'
	pn [[ Ты своими руками убил не менее двух противников, поэтому, вечером получил прекрасный трофей.]]
	pn '{cut}'
	pn [[ В дополнение к своей доле добычи получаешь шлем с антилопьими рогами – лишь очень немногим солдатам из всего войска достались такие.]]
	pn '{cut}'
	pn [[ Это – символ расположения вождя:
	- Запомни орк, для всех я – фельдфебель Рестелин, но ты можешь звать меня просто Рестл!]]
	pn '{cut}'
	p '{code ways():enable_all()}'
	end,
	way = {vroom(txtc('^Можно вернуться с трофеями в свое племя.^^'), 'r32'); vroom(txtc('^Или не возвращаться.^^'), 'r11')}
}

r42 = cutscene{
	nam = true,
	dsc = function(s)
	p '{code ways():disable_all()}'
	pn [[ После смерти в этом мире, ты вновь очутился на серой и безжизненной пустоши, где прошла твоя монотонная и скучная жизнь, со всем своим скарбом.]]
	pn '{cut}'
	pn [[
 Обстановка унылая и скучная, да и просто ужасная, и вроде бы когда-то тебя что-то заботило и беспокоило.]]
	pn '{cut}'
	pn '{walk r1}'
	end,
}