/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.OrCondition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class XorCondition
extends OrCondition {
    private static final long serialVersionUID = 3148555083095194992L;

    public XorCondition() {
    }

    public XorCondition(Condition condition, Condition condition2) {
        super(condition, condition2);
    }

    public void readFromXML(IXMLElement iXMLElement) {
        try {
            if (iXMLElement.getChildrenCount() != 2) {
                Debug.log("xor-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(1));
        }
        catch (Exception exception) {
            Debug.log("missing element in xor-condition");
        }
    }

    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        boolean bl = this.leftoperand.isTrue();
        boolean bl2 = this.rightoperand.isTrue();
        if (bl && bl2) {
            return false;
        }
        return bl || bl2;
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>");
        stringBuffer.append(this.leftoperand.getDependenciesDetails());
        stringBuffer.append("</li> XOR <li>");
        stringBuffer.append(this.rightoperand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }
}

