/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final String INITAL_PACKSELECTION = "initial.pack.selection";
    private List packs;
    private List packsToInstall;
    private Map installedpacks;
    private boolean modifyinstallation;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map<String, Pack> namesObj;
    Map<String, Integer> namesPos;
    private RulesEngine rules;
    private Properties variables;

    public PacksModel(PacksPanelInterface packsPanelInterface, InstallData installData, RulesEngine rulesEngine) {
        this.modifyinstallation = Boolean.valueOf(installData.getVariable("modify.izpack.install"));
        this.installedpacks = new HashMap();
        if (this.modifyinstallation) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(installData.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                List list = (List)objectInputStream.readObject();
                for (Object object : list) {
                    Pack pack = (Pack)object;
                    if (pack.id != null && pack.id.length() > 0) {
                        this.installedpacks.put(pack.id, pack);
                        continue;
                    }
                    this.installedpacks.put(pack.name, pack);
                }
                this.removeAlreadyInstalledPacks(installData.selectedPacks);
                Debug.trace("Found " + list.size() + " installed packs");
                Properties properties = (Properties)objectInputStream.readObject();
                for (Object e : properties.keySet()) {
                    installData.setVariable((String)e, (String)properties.get(e));
                }
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        this.rules = rulesEngine;
        this.packs = installData.availablePacks;
        this.packsToInstall = installData.selectedPacks;
        this.panel = packsPanelInterface;
        this.variables = installData.getVariables();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(true));
        this.langpack = packsPanelInterface.getLangpack();
        this.checkValues = new int[this.packs.size()];
        this.reverseDeps();
        this.initvalues();
        this.updateConditions(true);
        this.refreshPacksToInstall();
        this.variables.setProperty(INITAL_PACKSELECTION, Boolean.toString(false));
    }

    private void removeAlreadyInstalledPacks(List list) {
        ArrayList<Pack> arrayList = new ArrayList<Pack>();
        for (Object object : list) {
            Pack pack = (Pack)object;
            String string = "";
            string = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (!this.installedpacks.containsKey(string)) continue;
            arrayList.add(pack);
        }
        for (Pack pack : arrayList) {
            list.remove(pack);
        }
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean bl) {
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (Object e : this.packs) {
                Pack pack = (Pack)e;
                int n = this.getPos(pack.name);
                Debug.trace("Conditions fulfilled for: " + pack.name + "?");
                if (this.rules.canInstallPack(pack.id, this.variables)) continue;
                Debug.trace("no");
                if (this.rules.canInstallPackOptional(pack.id, this.variables)) {
                    Debug.trace("optional");
                    Debug.trace(pack.id + " can be installed optionally.");
                    if (!bl || this.checkValues[n] == 0) continue;
                    this.checkValues[n] = 0;
                    bl2 = true;
                    break;
                }
                Debug.trace(pack.id + " can not be installed.");
                if (this.checkValues[n] == -2) continue;
                this.checkValues[n] = -2;
                bl2 = true;
                break;
            }
            this.refreshPacksToInstall();
        }
    }

    private void reverseDeps() {
        Pack pack;
        this.namesObj = new HashMap<String, Pack>();
        for (Object e : this.packs) {
            pack = (Pack)e;
            this.namesObj.put(pack.name, pack);
        }
        for (Object e : this.packs) {
            pack = (Pack)e;
            List<String> list = pack.dependencies;
            for (int i = 0; list != null && i < list.size(); ++i) {
                String string = list.get(i);
                Pack pack2 = this.namesObj.get(string);
                pack2.addRevDep(pack.name);
            }
        }
    }

    private void initvalues() {
        Object object;
        Pack pack3;
        int n;
        this.namesPos = new HashMap<String, Integer>();
        for (n = 0; n < this.packs.size(); ++n) {
            pack3 = (Pack)this.packs.get(n);
            this.namesPos.put(pack3.name, n);
        }
        for (n = 0; n < this.packs.size(); ++n) {
            pack3 = (Pack)this.packs.get(n);
            if (!this.packsToInstall.contains(pack3)) continue;
            this.checkValues[n] = 1;
        }
        for (n = 0; n < this.packs.size(); ++n) {
            pack3 = (Pack)this.packs.get(n);
            if (this.checkValues[n] == 0) {
                object = pack3.revDependencies;
                for (int i = 0; object != null && i < object.size(); ++i) {
                    String string = (String)object.get(i);
                    int n2 = this.getPos(string);
                    this.checkValues[n2] = -2;
                }
            }
            if (this.checkValues[n] <= 0 || pack3.excludeGroup == null) continue;
            for (int i = 0; i < this.packs.size(); ++i) {
                if (i == n) continue;
                Pack pack2 = (Pack)this.packs.get(i);
                if (!pack3.excludeGroup.equals(pack2.excludeGroup) || this.checkValues[i] != 1) continue;
                this.checkValues[i] = 0;
            }
        }
        for (Pack pack3 : this.packs) {
            object = pack3;
            if (!((Pack)object).required) continue;
            this.propRequirement(((Pack)object).name);
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String string) {
        int n = this.getPos(string);
        this.checkValues[n] = -1;
        List<String> list = ((Pack)this.packs.get((int)n)).dependencies;
        for (int i = 0; list != null && i < list.size(); ++i) {
            String string2 = list.get(i);
            this.propRequirement(string2);
        }
    }

    private int getPos(String string) {
        return this.namesPos.get(string);
    }

    public int getRowCount() {
        return this.packs.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.checkValues[n] < 0) {
            return false;
        }
        return n2 == 0;
    }

    public Object getValueAt(int n, int n2) {
        Pack pack = (Pack)this.packs.get(n);
        switch (n2) {
            case 0: {
                return this.checkValues[n];
            }
            case 1: {
                String string = null;
                if (this.langpack != null && pack.id != null && !pack.id.equals("")) {
                    string = this.langpack.get(pack.id);
                }
                if (string == null || "".equals(string)) {
                    string = pack.name;
                }
                return string;
            }
            case 2: {
                return Pack.toByteUnitsString(pack.nbytes);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Integer) {
            Pack pack = (Pack)this.packs.get(n);
            boolean bl = false;
            if ((Integer)object == 1) {
                bl = true;
                String string = pack.id;
                if (string != null) {
                    if (this.rules.canInstallPack(string, this.variables) || this.rules.canInstallPackOptional(string, this.variables)) {
                        this.checkValues[n] = pack.required ? -1 : 1;
                    }
                } else {
                    this.checkValues[n] = pack.required ? -1 : 1;
                }
            } else {
                bl = false;
                this.checkValues[n] = 0;
            }
            this.updateExcludes(n);
            this.updateDeps();
            if (bl) {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after adding pack " + pack.id);
                }
                this.packsToInstall.add(pack);
            } else {
                if (this.panel.getDebugger() != null) {
                    this.panel.getDebugger().packSelectionChanged("after removing pack " + pack.id);
                }
                this.packsToInstall.remove(pack);
            }
            this.updateConditions();
            if (bl) {
                this.packsToInstall.remove(pack);
            } else {
                this.packsToInstall.add(pack);
            }
            this.updateBytes();
            this.fireTableDataChanged();
            this.refreshPacksToInstall();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        String string;
        Pack pack;
        int n;
        this.packsToInstall.clear();
        for (n = 0; n < this.packs.size(); ++n) {
            pack = (Pack)this.packs.get(n);
            string = "";
            string = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (Math.abs(this.checkValues[n]) != 1 || this.installedpacks.containsKey(string)) continue;
            this.packsToInstall.add(pack);
        }
        for (n = 0; n < this.packs.size(); ++n) {
            pack = (Pack)this.packs.get(n);
            string = "";
            string = pack.id != null && pack.id.length() > 0 ? pack.id : pack.name;
            if (!this.installedpacks.containsKey(string)) continue;
            this.checkValues[n] = -3;
        }
    }

    private void updateDeps() {
        int n;
        int[] nArray = new int[this.packs.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        this.dfs(nArray);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0 && this.checkValues[n] < 0) {
                int n2 = n;
                this.checkValues[n2] = this.checkValues[n2] + 2;
            }
            if (nArray[n] != 1 || this.checkValues[n] < 0) continue;
            this.checkValues[n] = -2;
        }
        for (Object e : this.packs) {
            Pack pack = (Pack)e;
            if (!pack.required) continue;
            String string = pack.id;
            if (string != null) {
                if (!this.rules.canInstallPack(string, this.variables) && this.rules.canInstallPackOptional(string, this.variables)) continue;
                this.propRequirement(pack.name);
                continue;
            }
            this.propRequirement(pack.name);
        }
    }

    private void updateExcludes(int n) {
        int n2 = this.checkValues[n];
        Pack pack = (Pack)this.packs.get(n);
        if (n2 > 0 && pack.excludeGroup != null) {
            for (int i = 0; i < this.packs.size(); ++i) {
                if (n == i) continue;
                Pack pack2 = (Pack)this.packs.get(i);
                String string = pack.excludeGroup;
                String string2 = pack2.excludeGroup;
                if (!string.equals(string2) || this.checkValues[i] != 1) continue;
                this.checkValues[i] = 0;
            }
        }
    }

    private void updateBytes() {
        long l = 0L;
        for (int i = 0; i < this.packs.size(); ++i) {
            if (Math.abs(this.checkValues[i]) != 1) continue;
            Pack pack = (Pack)this.packs.get(i);
            l += pack.nbytes;
        }
        this.panel.setBytes(l);
    }

    private int dfs(int[] nArray) {
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean bl;
            for (Object e : this.packs) {
                ((Pack)e).color = 0;
            }
            Pack pack = (Pack)this.packs.get(i);
            if (this.dfsVisit(pack, nArray, bl = false) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack pack, int[] nArray, boolean bl) {
        List<String> list;
        pack.color = 1;
        int n = this.checkValues[this.getPos(pack.name)];
        if (Math.abs(n) != 1) {
            bl = true;
        }
        if ((list = pack.revDependencies) != null) {
            for (String string : list) {
                int n2;
                Pack pack2 = this.namesObj.get(string);
                if (bl) {
                    nArray[this.getPos((String)pack2.name)] = 1;
                }
                if (pack2.color != 0 || (n2 = this.dfsVisit(pack2, nArray, bl)) == 0) continue;
                return n2;
            }
        }
        pack.color = 2;
        return 0;
    }

    public Map getInstalledpacks() {
        return this.installedpacks;
    }

    public boolean isModifyinstallation() {
        return this.modifyinstallation;
    }
}

