/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class NotCondition
extends Condition {
    private static final long serialVersionUID = 3194843222487006309L;
    protected Condition operand;

    public NotCondition() {
    }

    public NotCondition(Condition condition) {
        this.operand = condition;
    }

    public void readFromXML(XMLElement xMLElement) {
        try {
            if (xMLElement.getChildrenCount() != 1) {
                Debug.log("not-condition needs one condition as operand");
                return;
            }
            this.operand = RulesEngine.analyzeCondition(xMLElement.getChildAtIndex(0));
        }
        catch (Exception exception) {
            Debug.log("missing element in not-condition");
        }
    }

    public boolean isTrue() {
        return !this.operand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>NOT ");
        stringBuffer.append(this.operand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }
}

