/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class UserCondition
extends Condition {
    private static final long serialVersionUID = -2076347348048202718L;
    private String requiredUsername;

    public boolean isTrue() {
        boolean bl = false;
        if (this.requiredUsername == null) {
            Debug.log("Expected user name not set in user condition. Condition will return false.");
        } else {
            String string = System.getProperty("user.name");
            if (string != null || string.length() >= 0) {
                bl = this.requiredUsername.equals(string);
            } else {
                Debug.log("No user.name found in system properties. Condition will return false.");
            }
        }
        return bl;
    }

    public void readFromXML(XMLElement xMLElement) {
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("requiredusername");
        if (xMLElement2 == null) {
            Debug.log("Condition or type \"user\" requires child element: user");
        } else {
            this.requiredUsername = xMLElement2.getContent();
        }
    }
}

