<?php
/*
Plugin Name: Aventurien Zeit
Plugin URI: http://www.bdsa.de
Description: Dieses Plugin ersetzt die Datumausgabe von 'the_time' durch die Aventurische Zeit.
Author: Olaf Felten
Version: 0.2
Author URI: http://www.bdsa.de
*/

$plgn_version = "0.2";



function aventurien_time($x, $d) {
	global $post;
	if ($d == '') { $d = 'n. F Y'; }
	
	$wochentagname = array("Erdtag", "Markttag", "Praiostag", "Rohalstag", "Feuertag", "Wassertag", "Windstag");  // Array fr aventurische Wochentage
	$wochentagname_kurz = array("Ro", "Fe", "Wa", "Wi", "Er", "Ma","Pr");  // Array fr aventurische Wochentage kurzform
	$marray = array("Praios", "Rondra", "Efferd", "Travia", "Boron", "Hesinde", "Firun", "Tsa", "Phex", "Peraine", "Ingerimm", "Rahja", "Tag des Namenlosen"); 
	$mkarray = array("PRA", "RON", "EFF", "TRA", "BOR", "HES", "FIR", "TSA", "PHE", "PER", "ING", "RAH", "Tag des Namenlosen"); 
	
	$time = $post->post_date;
	$time = $post->post_date_gmt;
	
	$jahr = mysql2date("Y", $time)-1970; // date("Y") liefert vierstelliges Jahr 
	
	
	$jahrbf 	= 993 + $jahr. " Bosparans Fall"; //  -> Umrechnung zu Hal (+30)
	$jahrhal 	= $jahr. " Hal"; // -> Umrechnung zu Hal (+30)
	$jahrhoras 	= 1492 + 993 + jahr. " Horas"; // -> Umrechnung zu Hal (+30)
	
	$jahrbf_kurz 	= 993 + $jahr. " BF"; //  -> Umrechnung zu Hal 
	$jahrhal_kurz 	= $jahr. " Hal"; // -> Umrechnung zu Hal (+30)
	$jahrhoras_kurz = 1492 + 993 + jahr. " Hor"; // -> Umrechnung zu Hal (+30)
	               
	
	$tag_jahr = mysql2date("z", $time);
	if ((mysql2date("L", $time) == 1)&&($tag_jahr >= 60)){
		$tag_jahr = $tag_jahr - 1; }
	$tag = $tag_jahr%30+1;
	
	$monat = $marray[floor($tag_jahr/30)];	
	$monatkurz = $mkarray[floor($tag_jahr/30)];
	
	$mod = array("0", "2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24");
	$summe = $tag + $mod[floor($tag_jahr/30)] + ($jahr % 28);
	$wochentag = $wochentagname[($summe % 7)];
	$wochentagkurz = $wochentagname_kurz[($summe % 7)];
	
	

	# Ersetzen der Datumsparameter in das Aventurische Format
	
	for($i=0;$i<strlen($d);$i++) {
  		$explode[$i] = substr($d, $i, 1);
  		#echo "\"".$explode[$i]."\"";
  		switch ($explode[$i]){
			case "D": 
        $actdate[$i] = $wochentagkurz;
        break;
			case "l":
				$actdate[$i] = $wochentag;
        break;
			case "F":
				$actdate[$i] = $monat;
        break;
			case "m":
				$actdate[$i] = $monatkurz;
        break;
			case "M":
				$actdate[$i] = $monatkurz;
        break;
			case "n":
				$actdate[$i] = $monatkurz;
        break;
      case "y":
          if ( "bf" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrbf_kurz;
          }
          elseif ( "ha" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrhal_kurz;
          }
          elseif ( "ho" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrhoras_kurz;
          }
          else { $jahrbf_kurz; }
        break;
			case "Y":
				if ( "bf" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrbf;
          }
          elseif ( "ha" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrhal;
          }
          elseif ( "ho" == get_option("aventurien_date_option")){
            $actdate[$i] = $jahrhoras;
          }
          else { $jahrbf; }
        break;
			case "j":
				$actdate[$i] = $tag;
        break;
      case "r":
				$actdate[$i] = mysql2date("j.n.Y, H:i", $time);
        break;
			default:
				$actdate[$i] = mysql2date($explode[$i], $time);
			break;
		
		}
	  /*
	  
	  Nicht umgewandelt werden: a,A,B,c,d,g,G,h,H,i,I,j,L,o,s,S,t,T,U,w,W,z,Z
	  ToDo
      g 	12-Stunden-Format, ohne fhrende Nullen 	1 bis 12
      G 	24-Stunden-Format, ohne fhrende Nullen 	0 bis 23
      h 	12-Stunden-Format, mit fhrenden Nullen 	01 bis 12
      H 	24-Stunden-Format, mit fhrenden Nullen 	00 bis 23
      i 	Minuten mit fhrenden Nullen 	00 bis 59
      I 	Fllt ein Datum in die Sommerzeit 	1 bei Sommerzeit, ansonsten 0.
      j 	Tag des Monats ohne fhrende Nullen 	1 bis 31
      L 	Schaltjahr oder nicht 	1 fr ein Schaltjahr, ansonsten 0.
      O 	Zeitunterschied zur Greenwich time (GMT) in Stunden 	Beispiel: +0200
      r 	 RFC 2822 formatiertes Datum 	Beispiel: Thu, 21 Dec 2000 16:01:07 +0200
      s 	Sekunden, mit fhrenden Nullen 	00 bis 59
      S 	Anhang der englischen Aufzhlung fr einen Monatstag, zwei Zeichen 	st, nd, rd oder th. Zur Verwendung mit j empfohlen.
      t 	Anzahl der Tage des angegebenen Monats 	28 bis 31
      T 	Zeitzoneneinstellung des Rechners 	Beispiele: EST, MDT ...
      U 	Sekunden seit Beginn der UNIX-Epoche (January 1 1970 00:00:00 GMT) 	Siehe auch time()
      w 	Numerischer Tag einer Woche 	0 (fr Sonntag) bis 6 (fr Samstag)
      W 	ISO-8601 Wochennummer des Jahres, die Woche beginnt am Montag (hinzugefgt in PHP 4.1.0) 	Beispiel: 42 (die 42 Woche im Jahr)
      z 	Der Tag eines Jahres 	0 bis 365
      Z	  Offset der Zeitzone in Sekunden. Der Offset fr Zeitzone West nach UTC ist immer negativ und fr Zeitzone Ost nach UTC immer positiv
	   */
     
      
    
	}

	echo join($actdate);
	
}
function aventurien_date_option_page() {
	 global $plgn_version;
?>

<!-- Start Optionen im Adminbereich (xhtml, auerhalb PHP) -->
        <div class="wrap">
          <h2>Aventurien Zeit Optionen (Version <?php echo($plgn_version); ?>)</h2>
          <p>Dieses Plugin ersetzt die Datums-/ Zeitausgabe von WordPress durch die aventurische Zeit. 
          Es m&uuml;ssen normalerweise keine &Auml;nderungen am Theme oder an anderen Plugins vorgenommen werden. 
          Die aventurische Zeitrechnung stammt aus dem Fantasy-Rollenspiel <strong>Das schwarze Auge</strong> 
          und ist eine fiktive Zeitrechnung auf dem Kontinent Aventurien auf dem Planeten Dere.</p>
          <form name="aventurien_date_form" method="post" action="<?=$location ?>">
          <input name="action" value="insert" type="hidden" />
          <fieldset class="options"> 
          <legend>Zeitrechnung bestimmen</legend>
          
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

   	<tr valign="top"><td width="25%" align="right">
	<b>Zeitrechnung:</b>
	</td><td align="left"><select name="aventurien_date_select">
            <option valUe="bf" <?php if ("bf" == get_option("aventurien_date_option")) { echo "selected";}; ?>>Bosparans Fall</option>
            <option valUe="ha" <?php if ("ha" == get_option("aventurien_date_option")) { echo "selected";}; ?>>Hal</option>
            <option valUe="ho" <?php if ("ho" == get_option("aventurien_date_option")) { echo "selected";}; ?>>Horas</option>
          </select></td></tr>
	<tr valign="top">
        <td width="25%" align="right"></td>
        <td align="left"><input type="submit" value="Speichern" /></td></tr>
	</table>

	</fieldset>
  </form><br />             
  <fieldset class="options">  
          <legend>Parameter</legend>
          Folgende Parameter von <em>the_time</em> werden durch <strong>Aventurien Zeit</strong> ersetzt.
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

   	<tr valign="top">
             <td width="25%" align="right"><strong>Parameter</strong></td>
             <td align="left"><strong>Ausgabe</strong></td>
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'D'</strong></td>
             <td align="left">Gibt den aventurischen Wochentag in Kurzform zur&uuml;ck<br />
             Beispiel: <em>ROH</em> (f&uuml;r Rohalstag)</td>
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'l'</strong></td>
             <td align="left">Gibt den aventurischen Wochentag in zur&uuml;ck<br />
             Beispiel: <em>Rohalstag</em></td>
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'F'</strong></td>
             <td align="left">Gibt den aventurischen Monat zur&uuml;ck<br />
             Beispiel: <em>Praios</em></td>
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'m'</strong></td>
             <td align="left">Gibt den aventurischen Monat in Kurzform zur&uuml;ck<br />
             Beispiel: <em>PRA</em> (f&uuml;r Praios)</td>             
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'M'</strong></td>
             <td align="left">Gibt den aventurischen Monat in Kurzform zur&uuml;ck<br />
             Beispiel: <em>PRA</em> (f&uuml;r Praios)</td>
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'n'</strong></td>
             <td align="left">Gibt den aventurischen Monat in Kurzform zur&uuml;ck<br />
             Beispiel: <em>PRA</em> (f&uuml;r Praios)</td>
    </tr>
      <tr valign="top">
             <td width="25%" align="right">'y'</strong></td>
             <td align="left">Gibt das aventurische Jahr in Kurzform zur&uuml;ck<br />
             Beispiele:<br />
             <ul>
                <li><em>1031 BF</em> f&uuml;r Option "Bosparans Fall"</li>
                <li><em>38 Hal</em> f&uuml;r Option "Hal"</li>
                <li><em>2523 Hor</em> f&uuml;r Option "Horas"</li>
             </ul>
             
             </td>             
    </tr>
    <tr valign="top">
             <td width="25%" align="right">'y'</strong></td>
             <td align="left">Gibt das aventurische Jahr zur&uuml;ck<br />
             Beispiele:<br />
             <ul>
                <li><em>1031 Bosparans Fall</em> f&uuml;r Option "Bosparans Fall"</li>
                <li><em>38 Hal</em> f&uuml;r Option "Hal"</li>
                <li><em>2523 Horas</em> f&uuml;r Option "Horas"</li>
             </ul>
             
             </td>             
    </tr>
     <tr valign="top">
             <td width="25%" align="right">'j'</strong></td>
             <td align="left">Gibt den aventurischen Tag des Monats zur&uuml;ck<br />
             Beispiel: <em>1</em> (31. Januar = 1. Rondra!)</td>
    </tr>
      <tr valign="top">
             <td width="25%" align="right">'r'</strong></td>
             <td align="left">Gibt das irdische Datum mit Zeit zur&uuml;ck<br />
             Beispiel: <em>14.1.2008, 12:22</em></td>
    </tr>
	</table>

	</fieldset><br />
  <fieldset class="options"> 
          <legend>Copyrighthinweise</legend>
          <p>
          Verwendung der Marke und Inhalten von DAS SCHWARZE AUGE mit freundlicher Genehmigung der Ulisses Medien & Spiel 
          Distribution GmbH. Copyright &copy; 2007 by Significant GbR f&uuml;r die Marke DAS SCHWARZE AUGE in Wort und Bild, by Alpers, 
          Fuchs, Kramer, Neigel f&uuml;r die Inhalte.
          </p>

	</fieldset><br />
  <fieldset class="options"> 
          <legend>Danksagungen</legend>
          <p>
          F&uuml;r Tipps, Tricks und Anregungen m&ouml;chte ich mich ganz herzlich bei <em>Tronsha</em>, <em>Anton Weste</em> und <em>Henning Rosenhagen</em> bedanken.
          </p>

	</fieldset><br />
        <p class="copyright">Aventurien Zeit &copy; by <a href="http://www.bdsa.de">Olaf Felten</a> 2008-2010</p>
        </div>

<?php
} // Ende Funktion fb_meta_description_option_page()

// Adminmenu Optionen erweitern

function aventurien_date_add_menu() {
        add_option("aventurien_date_option","bf"); // optionsfield in Tabelle TABLEPRFIX_options
        add_options_page('Aventurien Zeit Optionen', 'Aventurien Zeit', 9, __FILE__, 'aventurien_date_option_page'); //optionenseite hinzufgen
}

if ('insert' == $HTTP_POST_VARS['action'])
{
    update_option("aventurien_date_option",$HTTP_POST_VARS['aventurien_date_select']);
}

# Registrieren der WordPress-Hooks
add_action('admin_menu', 'aventurien_date_add_menu');

# Filter fr 'the_time' aktivieren - aventurien_time ersetzt the_time
add_filter('the_time', 'aventurien_time', 10, 2);
?>