/*
 * Decompiled with CFR 0.152.
 */
package dsakalender;

import dsakalender.CommandHandler;
import dsakalender.date_input;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class DSAKalender
extends MIDlet
implements CommandListener {
    private Command cmd_list = null;
    private Command cmd_exit = null;
    private Command cmd_list_cmds = null;
    private Command cmd_get = null;
    private Display display = null;
    private List menu = null;
    private int day = 1;
    private int month = 1;
    private int year = 41;
    private String[] feier;
    private int counter = 1;
    private date_input my_in_form = null;

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        CommandHandler.getInstance().initialize(this);
        this.load();
        this.counter = 0;
        this.my_in_form = new date_input("Datum:");
        this.feier = new String[30];
        this.cmd_list = new Command("List", 4, 1);
        this.cmd_exit = new Command("Exit", 7, 1);
        this.cmd_list_cmds = new Command("Select", 4, 1);
        this.cmd_get = new Command("Ok", 4, 1);
        this.make_list();
        this.show_list();
    }

    public void destroyApp(boolean b) {
    }

    private void load() {
        RecordStore rs = null;
        ByteArrayInputStream bin = null;
        DataInputStream din = null;
        try {
            rs = RecordStore.openRecordStore((String)"Date", (boolean)false);
            byte[] data = rs.getRecord(1);
            bin = new ByteArrayInputStream(data);
            din = new DataInputStream(bin);
            this.day = din.readInt();
            this.month = din.readInt();
            this.year = din.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void make_list() {
        this.menu = new List("DSA-Kalender:", 3);
        this.menu.setSelectCommand(this.cmd_list_cmds);
        this.menu.append("Aktueller Tag", null);
        this.menu.append("Naechster Tag", null);
        this.menu.append("Letzter Tag", null);
        this.menu.append("Datum", null);
        this.menu.append("Woche anzeigen", null);
        this.menu.append("Monate anzeigen", null);
        this.menu.addCommand(this.cmd_exit);
    }

    private void save() {
        RecordStore rs = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            try {
                dout.writeInt(this.day);
                dout.writeInt(this.month);
                dout.writeInt(this.year);
                byte[] data = bout.toByteArray();
                rs = RecordStore.openRecordStore((String)"Date", (boolean)false);
                rs.setRecord(1, data, 0, data.length);
            }
            catch (RecordStoreException e) {
                try {
                    byte[] data = bout.toByteArray();
                    rs = RecordStore.openRecordStore((String)"Date", (boolean)true);
                    rs.addRecord(data, 0, data.length);
                }
                catch (RecordStoreException exc) {
                    e.printStackTrace();
                }
            }
            catch (Exception ep) {
                ep.printStackTrace();
            }
        }
        finally {
            try {
                dout.close();
                bout.close();
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Exception ep) {
                ep.printStackTrace();
            }
        }
    }

    private void show_list() {
        this.menu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.menu);
    }

    private boolean validdate() {
        return this.year >= 40 && this.month <= 13 && (this.month == 13 ? this.day <= 5 : this.day <= 30);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmd_get) {
            this.day = Integer.parseInt(this.my_in_form.iday.getString());
            this.month = Integer.parseInt(this.my_in_form.imonth.getString());
            this.year = Integer.parseInt(this.my_in_form.iyear.getString());
            this.show();
        }
        if (c == this.cmd_exit) {
            this.save();
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (c == this.cmd_list) {
            this.show_list();
        } else if (c == this.cmd_list_cmds) {
            switch (this.menu.getSelectedIndex()) {
                case 0: {
                    this.show();
                    break;
                }
                case 1: {
                    if (this.day < 30 && this.month < 13) {
                        ++this.day;
                    } else if (this.month == 13 && this.day < 5) {
                        ++this.day;
                    } else if (this.month == 13 && this.day == 5) {
                        this.day = 1;
                        this.month = 1;
                        ++this.year;
                    } else if (this.month < 13 && this.day == 30) {
                        this.day = 1;
                        ++this.month;
                    }
                    this.show();
                    break;
                }
                case 2: {
                    if (this.day > 1) {
                        --this.day;
                    } else if (this.day == 1 && this.month > 1) {
                        this.day = 30;
                        --this.month;
                    } else if (this.day == 1 && this.month == 1 && this.year > 40) {
                        this.day = 5;
                        this.month = 13;
                        --this.year;
                    }
                    this.show();
                    break;
                }
                case 3: {
                    this.input();
                    break;
                }
                case 4: {
                    this.show_week();
                    break;
                }
                case 5: {
                    this.show_month();
                    break;
                }
            }
        }
    }

    public void pauseApp() {
    }

    private void input() {
        this.my_in_form.ndsInit();
        this.my_in_form.addCommand(this.cmd_get);
        this.my_in_form.iday.setString(String.valueOf(this.day));
        this.my_in_form.imonth.setString(String.valueOf(this.month));
        this.my_in_form.iyear.setString(String.valueOf(this.year));
        this.my_in_form.setCommandListener(this);
        this.display.setCurrent((Displayable)this.my_in_form);
    }

    private void show_month() {
        Form my_Form = new Form("Monate Aventuriens");
        my_Form.append("J: Praios");
        my_Form.append("F: Rondra");
        my_Form.append("M: Efferd");
        my_Form.append("A: Travia");
        my_Form.append("M: Boron");
        my_Form.append("J: Hesinde");
        my_Form.append("J: Firun");
        my_Form.append("A: Tsa");
        my_Form.append("S: Phex");
        my_Form.append("O: Peraine");
        my_Form.append("N: Ingerimm");
        my_Form.append("D: Rahja");
        my_Form.append("-: Namenlos");
        my_Form.addCommand(this.cmd_list);
        my_Form.addCommand(this.cmd_exit);
        my_Form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)my_Form);
    }

    private void show_week() {
        Form my_Form = new Form("Woche Aventurien");
        my_Form.append("MO: Feuertag");
        my_Form.append("DI: Wassertag");
        my_Form.append("MI: Windstag");
        my_Form.append("DO: Erdstag");
        my_Form.append("FR: Markttag");
        my_Form.append("SA: Praiostag");
        my_Form.append("SO: Rohalstag");
        my_Form.addCommand(this.cmd_list);
        my_Form.addCommand(this.cmd_exit);
        my_Form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)my_Form);
    }

    private void show() {
        Form my_Form = new Form("DSA-Kalender");
        my_Form.append((Item)new StringItem("Info zum:", String.valueOf(this.day) + "." + this.printmonth() + "." + this.year + " Hal"));
        my_Form.append((Item)new StringItem("Wochentag:", this.pweek()));
        my_Form.append((Item)new StringItem("Jahreszeit:", this.pjahreszeit()));
        my_Form.append((Item)new StringItem("Mondphase:", this.pmond()));
        this.feiertage();
        int i = 0;
        while (i < this.counter) {
            my_Form.append((Item)new StringItem(String.valueOf(i + 1) + ". Feiertag:", this.feier[i]));
            ++i;
        }
        my_Form.addCommand(this.cmd_list);
        my_Form.addCommand(this.cmd_exit);
        my_Form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)my_Form);
    }

    private String printmonth() {
        switch (this.month) {
            case 1: {
                return "Praios";
            }
            case 2: {
                return "Rondra";
            }
            case 3: {
                return "Efferd";
            }
            case 4: {
                return "Travia";
            }
            case 5: {
                return "Boron";
            }
            case 6: {
                return "Hesinde";
            }
            case 7: {
                return "Firun";
            }
            case 8: {
                return "Tsa";
            }
            case 9: {
                return "Phex";
            }
            case 10: {
                return "Peraine";
            }
            case 11: {
                return "Ingerimm";
            }
            case 12: {
                return "Rahja";
            }
            case 13: {
                return "Namenlos";
            }
        }
        return "Error";
    }

    private String pjahreszeit() {
        switch (this.month) {
            case 1: 
            case 2: 
            case 12: 
            case 13: {
                return "Sommer\n";
            }
            case 3: 
            case 4: 
            case 5: {
                return "Herbst\n";
            }
            case 6: 
            case 7: 
            case 8: {
                return "Winter\n";
            }
            case 9: 
            case 10: 
            case 11: {
                return "Fruehling\n";
            }
        }
        return "Error";
    }

    private String prweek(int weekday) {
        switch (weekday) {
            case 0: {
                return "Feuertag";
            }
            case 1: {
                return "Wassertag";
            }
            case 2: {
                return "Windstag";
            }
            case 3: {
                return "Erdstag";
            }
            case 4: {
                return "Markttag";
            }
            case 5: {
                return "Praiostag";
            }
            case 6: {
                return "Rohalstag";
            }
        }
        return "Error";
    }

    private int wochentag() {
        int yearp = 0;
        int mond = 0;
        int days = 0;
        switch (this.month) {
            case 1: {
                yearp = this.year < 40 ? 40 - this.year : this.year - 40;
                days = this.day < 6 ? 6 - this.day : this.day - 6;
                mond = (yearp * 365 + days) % 7;
                return mond;
            }
            case 2: {
                yearp = this.year < 40 ? 40 - this.year : this.year - 40;
                mond = (yearp * 365 + this.day + 24) % 7;
                return mond;
            }
        }
        yearp = this.year < 40 ? 40 - this.year : this.year - 40;
        mond = (yearp * 365 + this.day + 24 + (this.month - 2) * 30) % 7;
        return mond;
    }

    private String pweek() {
        return this.prweek(this.wochentag());
    }

    int mondphase() {
        int yearp = 0;
        int mond = 0;
        int days = 0;
        switch (this.month) {
            case 1: {
                yearp = this.year < 40 ? 40 - this.year : this.year - 40;
                days = this.day < 6 ? 6 - this.day : this.day - 6;
                mond = (yearp * 365 + days) % 28;
                return mond;
            }
            case 2: {
                yearp = this.year < 40 ? 40 - this.year : this.year - 40;
                mond = (yearp * 365 + this.day + 24) % 28;
                return mond;
            }
        }
        yearp = this.year < 40 ? 40 - this.year : this.year - 40;
        mond = (yearp * 365 + this.day + 24 + (this.month - 2) * 30) % 28;
        return mond;
    }

    private String pmond() {
        int mond = this.mondphase();
        if (mond <= 6) {
            return "Mondphase des Helmes (" + (7 - mond) + " Tage bis zur naechsten Phase)";
        }
        if (mond <= 13) {
            return "Mondphase der toten und wiedergeborenen Mada (" + (14 - mond) + " Tage bis zur naechsten Phase)";
        }
        if (mond <= 20) {
            return "Mondphase des Kelchs (" + (21 - mond) + " Tage bis zur naechsten Phase)";
        }
        return "Mondphase des Rades (" + (28 - mond) + " Tage bis zur naechsten Phase)";
    }

    private void feiertage() {
        this.counter = 0;
        switch (this.month) {
            case 1: {
                this.fpraios();
                break;
            }
            case 2: {
                this.frondra();
                break;
            }
            case 3: {
                this.fefferd();
                break;
            }
            case 4: {
                this.ftravia();
                break;
            }
            case 5: {
                this.fboron();
                break;
            }
            case 6: {
                this.fhesinde();
                break;
            }
            case 7: {
                this.ffirun();
                break;
            }
            case 8: {
                this.ftsa();
                break;
            }
            case 9: {
                this.fphex();
                break;
            }
            case 10: {
                this.fperaine();
                break;
            }
            case 11: {
                this.fingerimm();
                break;
            }
            case 12: {
                this.frhaja();
                break;
            }
            case 13: {
                this.fnamenlos();
                break;
            }
        }
    }

    private void fpraios() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Sommersonnenwende";
            ++this.counter;
        }
        if (this.day == 2 || this.day == 3) {
            this.feier[this.counter] = "  --Praiosfest und Greifenfest(Mittelreich)";
            ++this.counter;
        }
        if (this.day < 9) {
            this.feier[this.counter] = "  --Garether Turnier(1. - 8. Praios)";
            ++this.counter;
        }
        if (this.day == 15 || this.day == 16) {
            this.feier[this.counter] = "  --Parade in Gareth";
            ++this.counter;
        }
        if (this.day == 17) {
            this.feier[this.counter] = "  --Reichsbehueter Brins Tsatag (Geburtstag)";
            ++this.counter;
        }
        if (this.day > 23 && this.day < 28) {
            this.feier[this.counter] = "  --Aufnahmeprfung der Beilunker Reiter (Beilunk)";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Tag der 2.Daemonenschlacht (Verbrennung der Daemonen in Brig-Lo)";
            ++this.counter;
        }
    }

    private void frondra() {
        if (this.day <= 3) {
            this.feier[this.counter] = "  --Gladiatorenkaempfe (Punin)";
            ++this.counter;
        }
        if (this.day == 5) {
            this.feier[this.counter] = "  --Tag des Schwurs";
            ++this.counter;
        }
        if (this.day > 5 && this.day < 10) {
            this.feier[this.counter] = "  --Zerstoerung Bosparans (Nationalfeiertag Mittelreich)";
            ++this.counter;
        }
        if (this.day != 8) {
            this.feier[this.counter] = "  --Theaterspiele in Arivor, Kuslik und Vinsalt";
            ++this.counter;
        }
        if (this.day == 8) {
            this.feier[this.counter] = "  --Bosparans Fall (Trauertag Horasreich)";
            ++this.counter;
        }
        if (this.day > 11 && this.day < 15) {
            this.feier[this.counter] = "  --Ritterturnier Barburin";
            ++this.counter;
        }
        if (this.day > 12 && this.day < 15) {
            this.feier[this.counter] = "  --Ritterturnier Nostria und Andergast";
            ++this.counter;
        }
        if (this.day > 14 && this.day < 17) {
            this.feier[this.counter] = "  --Schwertfest";
            ++this.counter;
        }
        if (this.day == 19) {
            this.feier[this.counter] = "  --Jahresbegin auf Maraskan";
            ++this.counter;
            this.feier[this.counter] = "  --Diskusstafette: Tuzak - Boran";
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Efferdsfahrt: Thorwal - Prem";
            ++this.counter;
        }
    }

    private void fefferd() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Efferdsfahrt: Thorwal - Prem";
            ++this.counter;
            this.feier[this.counter] = "  --Tag des Wassers";
            ++this.counter;
            this.feier[this.counter] = "  --Bunte Lichter von Pericum";
            ++this.counter;
            this.feier[this.counter] = "  --Flottenparade (Festum)";
            ++this.counter;
        }
        if (this.day == 2) {
            this.feier[this.counter] = "  --Efferdsfahrt: Thorwal - Prem";
            ++this.counter;
        }
        if (this.day == 9) {
            this.feier[this.counter] = "  --4. Rastullahellah";
            ++this.counter;
        }
        if (this.day == 16) {
            this.feier[this.counter] = "  --Nebelfest";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Fischerfest";
            ++this.counter;
            this.feier[this.counter] = "  --Pruefungsfest";
            ++this.counter;
        }
    }

    private void ftravia() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Tag der Heimkehr";
            ++this.counter;
        }
        if (this.day < 4) {
            this.feier[this.counter] = "  --Fest der eingebrachten Fruechte";
            ++this.counter;
        }
        if (this.day == 4) {
            this.feier[this.counter] = "  --Tag der Helden";
            ++this.counter;
        }
        if (this.day == 5) {
            this.feier[this.counter] = "  --Jagdturnier (Zorgan)";
            ++this.counter;
        }
        if (this.day == 12) {
            this.feier[this.counter] = "  --Tag der Treue";
            ++this.counter;
        }
        if (this.day > 14 && this.day < 22) {
            this.feier[this.counter] = "  --Weinfest im Yaquirtal";
            ++this.counter;
        }
        if (this.day == 29) {
            this.feier[this.counter] = "  --Todestag des Hl. Gilborn";
            ++this.counter;
        }
        if (this.day < 8) {
            this.feier[this.counter] = "  --Volksspiele in Lowangen";
            ++this.counter;
        }
        if (this.day < 15 && this.day > 6) {
            this.feier[this.counter] = "  --Immanmeisterschaften";
            ++this.counter;
        }
    }

    private void fboron() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Totenfest";
            ++this.counter;
        }
        if (this.day > 1 && this.day < 9) {
            this.feier[this.counter] = "  --Gauklertreffen (Khunchom)";
            ++this.counter;
        }
        if (this.day > 3 && this.day < 9) {
            this.feier[this.counter] = "  --Warenschau in Al'Anfa";
            ++this.counter;
        }
        if (this.day == 22) {
            this.feier[this.counter] = "  --5.Rastullahellah (hoechster Feiertag)";
            ++this.counter;
        }
        if (this.day == 23) {
            this.feier[this.counter] = "  --Tsatag von Hal dem I (Geburtstag)";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Tag des grossen Schlafes (Al'Anfa)";
            ++this.counter;
        }
    }

    private void fhesinde() {
        if (this.day == 7) {
            this.feier[this.counter] = "  --Rohalsverhllung (Magier)";
            ++this.counter;
        }
        if (this.day < 30 && this.day > 19) {
            this.feier[this.counter] = "  --Opernfestspiele (Vinsalt)";
            ++this.counter;
        }
        if (this.day == 29) {
            this.feier[this.counter] = "  --Tag der Volkskunst";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Erleuchtungsfest";
            ++this.counter;
        }
    }

    private void ffirun() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Tag der Jagd";
            ++this.counter;
            this.feier[this.counter] = "  --Wintersonnenwende";
            ++this.counter;
        }
        if (this.day == 8) {
            this.feier[this.counter] = "  --Nationalfeiertag";
            ++this.counter;
        }
        if (this.day == 11) {
            this.feier[this.counter] = "  --Tag des Hirsches (Bjaldorn)";
            ++this.counter;
        }
        if (this.day == 25) {
            this.feier[this.counter] = "  --Kamelrennen (Mherwed)";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Tag der Ifirn";
            ++this.counter;
        }
    }

    private void ftsa() {
        if (this.day == 5) {
            this.feier[this.counter] = "  --1. Rastullahellah";
            ++this.counter;
        }
        if (this.day == 19) {
            this.feier[this.counter] = "  --Tag der Unabhaengigkeit";
            ++this.counter;
        }
        if (this.day > 26) {
            this.feier[this.counter] = "  --Warenschau (Riva)";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Tag der Erneuerung";
            ++this.counter;
        }
    }

    private void fphex() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Tag der Erneuerung";
            ++this.counter;
        }
        if (this.day < 3) {
            this.feier[this.counter] = "  --Warenschau (Riva)";
            ++this.counter;
        }
        if (this.day == 16) {
            this.feier[this.counter] = "  --Tag des Phex";
            ++this.counter;
        }
        if (this.day == 18) {
            this.feier[this.counter] = "  --Basiliskentag (Jagd von Schleichen durch Punin)";
            ++this.counter;
        }
        if (this.day == 24) {
            this.feier[this.counter] = "  --Glueckstag";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Versenkungstag";
            ++this.counter;
        }
        if (this.day < 8) {
            this.feier[this.counter] = "  --Markt und Spiele in Lowangen";
            ++this.counter;
        }
    }

    private void fperaine() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Staatsfeiertag";
            ++this.counter;
        }
        if (this.day == 4) {
            this.feier[this.counter] = "  --Thalionmeltag Neetha";
            ++this.counter;
        }
        if (this.day > 6 && this.day < 13) {
            this.feier[this.counter] = "  --Jaehrliches Bardentreffen (abwechselnd in Honingen, Norburg, Bethana oder Zorgan)";
            ++this.counter;
        }
        if (this.day == 18) {
            this.feier[this.counter] = "  --2. Rastullahellah";
            ++this.counter;
        }
        if (this.day > 18 && this.day < 16) {
            this.feier[this.counter] = "  --Volksfest zum Rastullahellah in Fasar";
            ++this.counter;
        }
        if (this.day == 27) {
            this.feier[this.counter] = "  --Der Schutzwall zu Anchopal - ein Wunder (Anchopal)";
            ++this.counter;
            this.feier[this.counter] = "  --Maraskantag";
            ++this.counter;
        }
        if (this.day == 26) {
            this.feier[this.counter] = "  --Rgatta: Teremon - Rethis";
            ++this.counter;
        }
    }

    private void fingerimm() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --Tag des Feuers";
            ++this.counter;
        }
        if (this.day == 8) {
            this.feier[this.counter] = "  --Tag des Aufbruchs";
            ++this.counter;
        }
        if (this.day < 21 && this.day > 16) {
            this.feier[this.counter] = "  --Wagenrennen und Reiturnier in Punin";
            ++this.counter;
        }
        if (this.day == 19) {
            this.feier[this.counter] = "  --Tag der Katastrophe (Abilacht)";
            ++this.counter;
        }
        if (this.day == 21) {
            this.feier[this.counter] = "  --Tag der Waffenschmiede";
            ++this.counter;
        }
        if (this.day > 20 && this.day < 24) {
            this.feier[this.counter] = "  --Warenschau und Volksfest nach Zwergenart in Angbar";
            ++this.counter;
        }
        if (this.day == 22) {
            this.feier[this.counter] = "  --Schlacht an der Trollpforte";
            ++this.counter;
        }
        if (this.day > 23) {
            this.feier[this.counter] = "  --Warenschau in Festum";
            ++this.counter;
        }
    }

    private void frhaja() {
        if (this.day < 8) {
            this.feier[this.counter] = "  --Fest der Freuden";
            ++this.counter;
        }
        if (this.day > 7 && this.day < 13) {
            this.feier[this.counter] = "  --Warenschau und Spiele in Grangor";
            ++this.counter;
        }
        if (this.day > 19 && this.day < 26) {
            this.feier[this.counter] = "  --Ritterturnier in Arivor";
            ++this.counter;
        }
        if (this.day == 30) {
            this.feier[this.counter] = "  --Reinigunsfest Vorbereitung";
            ++this.counter;
        }
        this.feier[this.counter] = "  --Hunderennen in Greifenfurt";
        ++this.counter;
    }

    private void fnamenlos() {
        if (this.day == 1) {
            this.feier[this.counter] = "  --3. Rastullahellah";
            ++this.counter;
        }
    }
}

